/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.internal;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.fx.core.ObjectSerializer;
import org.osgi.service.component.annotations.Component;

@Component
public class JAXBObjectSerializer
implements ObjectSerializer {
    @Override
    public String getId() {
        return "jaxb";
    }

    @Override
    public String serialize(Object object) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (StringWriter w = new StringWriter();){
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
                Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
                jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                jaxbMarshaller.marshal(object, (Writer)w);
                return w.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <O> O deserialize(Class<O> clazz, String value) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (StringReader r = new StringReader(value);){
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                return (O)jaxbUnmarshaller.unmarshal((Reader)r);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

