/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.ui.mobile.sim.launch;

import java.io.File;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.fx.ide.ui.mobile.sim.launch.DeviceType;
import org.eclipse.fx.ide.ui.mobile.sim.launch.Orientation;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;

public class MobileSimulatorLaunchDelegate
extends JavaLaunchDelegate {
    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        HashSet<String> paths = new HashSet<String>(Arrays.asList(super.getClasspath(configuration)));
        paths.add(this.getSimulatorPath());
        return paths.toArray(new String[0]);
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        String s = super.getProgramArguments(configuration);
        s = String.valueOf(s) + " -deviceType " + configuration.getAttribute("org.eclipse.fx.ide.ui.mobile.sim.launch.DEVICE_TYPE", DeviceType.IPHONE.name());
        s = String.valueOf(s) + " -deviceOrientation " + configuration.getAttribute("org.eclipse.fx.ide.ui.mobile.sim.launch.DEVICE_ORIENTATION", Orientation.VERTICAL.name());
        s = String.valueOf(s) + " -displaySize " + configuration.getAttribute("org.eclipse.fx.ide.ui.mobile.sim.launch.DEVICE_SIZE", "640x1136");
        s = String.valueOf(s) + " -applicationClass " + configuration.getAttribute("org.eclipse.fx.ide.ui.mobile.sim.launch.APP_CLASS", "");
        return s;
    }

    private String getSimulatorPath() {
        File f;
        String installLocation;
        IPluginModelBase findModel = PDECore.getDefault().getModelManager().findModel("org.eclipse.fx.ide.ui.mobile.sim.device");
        String string = installLocation = findModel == null ? null : findModel.getInstallLocation();
        if (installLocation == null) {
            installLocation = Platform.getBundle((String)"org.eclipse.fx.ide.ui.mobile.sim.device").getLocation().substring("reference:file:".length());
            try {
                installLocation = new File(new File(Platform.getInstallLocation().getURL().toURI()), installLocation).toString();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            System.err.println("LOADING FROM: " + installLocation);
            System.out.println("LOADING FROM: " + installLocation);
        }
        if ((f = new File(installLocation)).isDirectory()) {
            return String.valueOf(installLocation) + "/bin";
        }
        return installLocation;
    }
}

