/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.osgi.service.url.AbstractURLStreamHandlerService;

public class MvnProtocolHandlerService
extends AbstractURLStreamHandlerService {
    public URLConnection openConnection(URL url) {
        return new MavenURLConnection(url);
    }

    private static final class MavenURLConnection
    extends URLConnection {
        private String subPath;
        private ArtifactResult artifactResult;

        protected MavenURLConnection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
            String[] coordinates;
            if (this.artifactResult != null) {
                return;
            }
            String path = this.url.getPath();
            if (path == null) {
                throw new IOException("maven coordinates are missing");
            }
            int subPathIndex = path.indexOf(47);
            if (subPathIndex > -1) {
                this.subPath = path.substring(subPathIndex);
                coordinates = path.substring(0, subPathIndex).split(":");
            } else {
                coordinates = path.split(":");
            }
            if (coordinates.length < 3) {
                throw new IOException("required format is groupId:artifactId:version[:packaging[:classifier]]");
            }
            String type = coordinates.length > 3 ? coordinates[3] : "jar";
            String classifier = coordinates.length > 4 ? coordinates[4] : null;
            DefaultArtifact artifact = new DefaultArtifact(coordinates[0], coordinates[1], classifier, type, coordinates[2]);
            try {
                IMaven maven = MavenPlugin.getMaven();
                RepositorySystem repoSystem = MavenPluginActivator.getDefault().getRepositorySystem();
                IMavenExecutionContext context = maven.createExecutionContext();
                List<ArtifactRepository> artifactRepositories = maven.getArtifactRepositories();
                List remoteRepositories = RepositoryUtils.toRepos(artifactRepositories);
                this.artifactResult = context.execute(new ICallable<ArtifactResult>((Artifact)artifact, remoteRepositories, repoSystem){
                    private final /* synthetic */ Artifact val$artifact;
                    private final /* synthetic */ List val$remoteRepositories;
                    private final /* synthetic */ RepositorySystem val$repoSystem;
                    {
                        this.val$artifact = artifact;
                        this.val$remoteRepositories = list;
                        this.val$repoSystem = repositorySystem;
                    }

                    @Override
                    public ArtifactResult call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                        ArtifactRequest artifactRequest = new ArtifactRequest(this.val$artifact, this.val$remoteRepositories, null);
                        RepositorySystemSession session = context.getRepositorySession();
                        try {
                            return this.val$repoSystem.resolveArtifact(session, artifactRequest);
                        }
                        catch (ArtifactResolutionException e) {
                            throw new CoreException((IStatus)new Status(4, MvnProtocolHandlerService.class.getPackage().getName(), "Resolving artifact failed", (Throwable)e));
                        }
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new IOException("resolving artifact " + artifact + " failed", e);
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            if (this.artifactResult == null || this.artifactResult.isMissing()) {
                throw new FileNotFoundException();
            }
            File location = this.artifactResult.getArtifact().getFile();
            if (this.subPath == null) {
                return new FileInputStream(location);
            }
            String urlSpec = "jar:" + location.toURI() + "!" + this.subPath;
            return new URL(urlSpec).openStream();
        }
    }
}

