/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.fx.core.KeyValueStore;
import org.eclipse.fx.core.OSGiUtil;
import org.eclipse.fx.core.SystemUtils;
import org.eclipse.fx.core.internal.JavaDSServiceProcessor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ServiceUtils {
    static <S> @Nullable S _lookupService(@Nullable Class<?> requestor, @NonNull Class<S> serviceClass) {
        List<@NonNull S> _lookupServiceList = ServiceUtils._lookupServiceList(requestor, serviceClass);
        if (!_lookupServiceList.isEmpty()) {
            return _lookupServiceList.get(0);
        }
        return null;
    }

    static <S> @Nullable S _lookupService(@Nullable Class<?> requestor, @NonNull String serviceClass) {
        List<@NonNull S> _lookupServiceList = ServiceUtils._lookupServiceList(requestor, serviceClass);
        if (!_lookupServiceList.isEmpty()) {
            return _lookupServiceList.get(0);
        }
        return null;
    }

    static <S> @NonNull List<@NonNull S> _lookupServiceList(@Nullable Class<?> requestor, @NonNull Class<S> serviceClass) {
        if (SystemUtils.isOsgiEnv()) {
            return OSGiUtil.lookupServiceList(requestor, serviceClass);
        }
        return JavaDSServiceProcessor.lookupServiceList(requestor, serviceClass);
    }

    static <S> @NonNull List<@NonNull S> _lookupServiceList(@Nullable Class<?> requestor, @NonNull String serviceClass) {
        if (SystemUtils.isOsgiEnv()) {
            return Collections.emptyList();
        }
        return JavaDSServiceProcessor.lookupServiceList(requestor, serviceClass);
    }

    public static <S> @NonNull Optional<S> getService(@NonNull Class<S> serviceClass) {
        @Nullable S v = ServiceUtils._lookupService(null, serviceClass);
        if (v == null) {
            return Optional.empty();
        }
        return Optional.of(v);
    }

    public static <S> @NonNull Optional<S> getService(@NonNull Class<?> requestor, @NonNull Class<S> serviceClass) {
        @Nullable S v = ServiceUtils._lookupService(requestor, serviceClass);
        if (v == null) {
            return Optional.empty();
        }
        return Optional.of(v);
    }

    public static <S> @NonNull List<@NonNull S> getServiceList(@NonNull Class<?> requestor, @NonNull Class<S> serviceClass) {
        return ServiceUtils._lookupServiceList(requestor, serviceClass);
    }

    public static <S> @NonNull List<@NonNull S> getServiceList(@NonNull Class<S> serviceClass) {
        return ServiceUtils._lookupServiceList(null, serviceClass);
    }

    public static <S> Optional<ServiceReference<S>> getServiceReference(Class<S> clazz) {
        List<ServiceReference<S>> list = ServiceUtils.getServiceReferenceList(clazz);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(list.get(0));
    }

    public static <S> Optional<ServiceReference<S>> getServiceReference(Class<?> requestor, Class<S> clazz) {
        List<ServiceReference<S>> list = ServiceUtils.getServiceReferenceList(requestor, clazz);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(list.get(0));
    }

    public static <S> List<ServiceReference<S>> getServiceReferenceList(Class<S> clazz) {
        if (SystemUtils.isOsgiEnv()) {
            return OSGiUtil.lookupServiceReferenceList(null, clazz);
        }
        return JavaDSServiceProcessor.lookupServiceReferenceList(null, clazz);
    }

    public static <S> List<ServiceReference<S>> getServiceReferenceList(Class<?> requestor, Class<S> clazz) {
        if (SystemUtils.isOsgiEnv()) {
            return OSGiUtil.lookupServiceReferenceList(requestor, clazz);
        }
        return JavaDSServiceProcessor.lookupServiceReferenceList(null, clazz);
    }

    public static <S> Optional<S> getService(@NonNull String serviceClass) {
        S rv = ServiceUtils._lookupService(null, serviceClass);
        return rv == null ? Optional.empty() : Optional.of(rv);
    }

    public static interface ServiceReference<S>
    extends Comparable<ServiceReference<S>> {
        public S get();

        public int getRanking();

        public KeyValueStore<String, Object> getProperties();

        @Override
        default public int compareTo(ServiceReference<S> o) {
            return Integer.compare(this.getRanking(), o.getRanking());
        }
    }
}

