/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ui.panes.SashPane;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BaseSashRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WSash;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWidget;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.WLayoutedWidgetImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DefSashRenderer
extends BaseSashRenderer<Node> {
    protected Class<? extends WSash<Node>> getWidgetClass(MPartSashContainer container) {
        if (container.getTags().contains("fx_fixedLayout")) {
            return WFixedSashImpl.class;
        }
        if (Boolean.getBoolean("efxclipse.eclipse.compat.sash")) {
            return WResizableSashImpl_2.class;
        }
        return WResizableSashImpl.class;
    }

    protected boolean detachHiddenChild() {
        return !Boolean.getBoolean("efxclipse.eclipse.compat.sash");
    }

    public static class WFixedSashImpl
    extends WLayoutedWidgetImpl<GridPane, Node, MPartSashContainer>
    implements WSash<Node> {
        private final @NonNull MPartSashContainer domainElement;

        static RowConstraints toRowConstraint(Map<String, String> dataMap) {
            RowConstraints r;
            if (dataMap.containsKey("fx_layout_height")) {
                int h = Integer.parseInt(dataMap.get("fx_layout_height"));
                r = new RowConstraints((double)h);
            } else {
                r = new RowConstraints();
            }
            if (dataMap.containsKey("fx_layout_grab_vertical") && Boolean.parseBoolean(dataMap.get("fx_layout_grab_vertical"))) {
                r.setVgrow(Priority.ALWAYS);
            }
            return r;
        }

        static ColumnConstraints toColConstraint(Map<String, String> dataMap) {
            ColumnConstraints c;
            if (dataMap.containsKey("fx_layout_width")) {
                int w = Integer.parseInt(dataMap.get("fx_layout_width"));
                c = new ColumnConstraints((double)w);
            } else {
                c = new ColumnConstraints();
            }
            if (dataMap.containsKey("fx_layout_grab_horizontal") && Boolean.parseBoolean(dataMap.get("fx_layout_grab_horizontal"))) {
                c.setHgrow(Priority.ALWAYS);
            }
            return c;
        }

        @Inject
        public WFixedSashImpl(@Named(value="fx.rendering.domElement") @NonNull MPartSashContainer domainElement) {
            this.domainElement = domainElement;
        }

        public int getItemCount() {
            return ((GridPane)this.getWidget()).getChildren().size();
        }

        private static void fixIndex(GridPane p, MPartSashContainer c) {
            if (c.isHorizontal()) {
                int i = 0;
                for (Node n : p.getChildren()) {
                    GridPane.setColumnIndex((Node)n, (Integer)i);
                    Map map = ((MPartSashContainerElement)c.getChildren().get(i)).getPersistedState();
                    if (map.containsKey("fx_layout_grab_vertical")) {
                        if (Boolean.parseBoolean((String)map.get("fx_layout_grab_vertical"))) {
                            GridPane.setFillHeight((Node)n, (Boolean)Boolean.TRUE);
                            GridPane.setVgrow((Node)n, (Priority)Priority.ALWAYS);
                        }
                    } else {
                        GridPane.setFillHeight((Node)n, (Boolean)Boolean.TRUE);
                        GridPane.setVgrow((Node)n, (Priority)Priority.ALWAYS);
                    }
                    ++i;
                }
            } else {
                int i = 0;
                for (Node n : p.getChildren()) {
                    GridPane.setRowIndex((Node)n, (Integer)i);
                    Map map = ((MPartSashContainerElement)c.getChildren().get(i)).getPersistedState();
                    if (map.containsKey("fx_layout_grab_horizontal")) {
                        if (Boolean.parseBoolean((String)map.get("fx_layout_grab_horizontal"))) {
                            GridPane.setHgrow((Node)n, (Priority)Priority.ALWAYS);
                            GridPane.setFillWidth((Node)n, (Boolean)Boolean.TRUE);
                        }
                    } else {
                        GridPane.setHgrow((Node)n, (Priority)Priority.ALWAYS);
                        GridPane.setFillWidth((Node)n, (Boolean)Boolean.TRUE);
                    }
                    ++i;
                }
            }
        }

        public void addItem(WLayoutedWidget<MPartSashContainerElement> widget) {
            Node n = (Node)widget.getStaticLayoutNode();
            GridPane p = (GridPane)this.getWidget();
            MPartSashContainer domElement = (MPartSashContainer)this.getDomElement();
            MPartSashContainerElement widgetElement = (MPartSashContainerElement)widget.getDomElement();
            if (domElement == null) {
                this.logger.log(Logger.Level.ERROR, "Could not find DOM element for '" + String.valueOf(this) + "'");
                return;
            }
            if (widgetElement == null) {
                this.logger.log(Logger.Level.ERROR, "Could not find DOM element for '" + String.valueOf(widget) + "'");
                return;
            }
            if (domElement.isHorizontal()) {
                p.getColumnConstraints().add((Object)WFixedSashImpl.toColConstraint(widgetElement.getPersistedState()));
            } else {
                p.getRowConstraints().add((Object)WFixedSashImpl.toRowConstraint(widgetElement.getPersistedState()));
            }
            p.getChildren().add((Object)n);
            WFixedSashImpl.fixIndex(p, domElement);
        }

        public void addItems(List<WLayoutedWidget<MPartSashContainerElement>> list) {
            ArrayList<Node> nodeList = new ArrayList<Node>();
            GridPane p = (GridPane)this.getWidget();
            MPartSashContainer domElement = (MPartSashContainer)this.getDomElement();
            if (domElement == null) {
                this.logger.log(Logger.Level.ERROR, "Could not find DOM element for '" + String.valueOf(this) + "'");
                return;
            }
            for (WLayoutedWidget<MPartSashContainerElement> w : list) {
                Node n = (Node)w.getStaticLayoutNode();
                MPartSashContainerElement widgetElement = (MPartSashContainerElement)w.getDomElement();
                if (widgetElement != null) {
                    if (domElement.isHorizontal()) {
                        p.getColumnConstraints().add((Object)WFixedSashImpl.toColConstraint(widgetElement.getPersistedState()));
                    } else {
                        p.getRowConstraints().add((Object)WFixedSashImpl.toRowConstraint(widgetElement.getPersistedState()));
                    }
                }
                nodeList.add(n);
            }
            p.getChildren().addAll(nodeList);
            WFixedSashImpl.fixIndex(p, domElement);
        }

        public void addItems(int index, List<WLayoutedWidget<MPartSashContainerElement>> list) {
            ArrayList<Node> nodeList = new ArrayList<Node>();
            GridPane p = (GridPane)this.getWidget();
            MPartSashContainer domElement = (MPartSashContainer)this.getDomElement();
            if (domElement == null) {
                this.logger.log(Logger.Level.ERROR, "Could not find DOM element for '" + String.valueOf(this) + "'");
                return;
            }
            ArrayList<ColumnConstraints> columnConstraints = new ArrayList<ColumnConstraints>();
            ArrayList<RowConstraints> rowConstraints = new ArrayList<RowConstraints>();
            for (WLayoutedWidget<MPartSashContainerElement> w : list) {
                Node n = (Node)w.getStaticLayoutNode();
                MPartSashContainerElement element = (MPartSashContainerElement)w.getDomElement();
                if (element != null) {
                    if (domElement.isHorizontal()) {
                        columnConstraints.add(WFixedSashImpl.toColConstraint(element.getPersistedState()));
                    } else {
                        rowConstraints.add(WFixedSashImpl.toRowConstraint(element.getPersistedState()));
                    }
                } else {
                    this.logger.log(Logger.Level.ERROR, "Could not find DOM element for '" + String.valueOf(w) + "'");
                    return;
                }
                nodeList.add(n);
            }
            if (domElement.isHorizontal()) {
                p.getColumnConstraints().addAll(index, columnConstraints);
            } else {
                p.getRowConstraints().addAll(index, rowConstraints);
            }
            p.getChildren().addAll(index, nodeList);
            WFixedSashImpl.fixIndex(p, domElement);
        }

        public void removeItem(WLayoutedWidget<MPartSashContainerElement> widget) {
            Node n = (Node)widget.getStaticLayoutNode();
            GridPane p = (GridPane)this.getWidget();
            MPartSashContainer domElement = (MPartSashContainer)this.getDomElement();
            if (domElement == null) {
                this.logger.log(Logger.Level.ERROR, "Could not find DOM element for '" + String.valueOf(this) + "'");
                return;
            }
            int idx = p.getChildren().indexOf((Object)n);
            if (domElement.isHorizontal()) {
                p.getColumnConstraints().remove(idx);
            } else {
                p.getRowConstraints().remove(idx);
            }
            p.getChildren().remove((Object)n);
            WFixedSashImpl.fixIndex(p, domElement);
        }

        @Override
        public Node getWidgetNode() {
            Node widget = (Node)this.getWidget();
            if (this.domainElement.getTags().contains("fx_scrollable")) {
                ScrollPane scroll = new ScrollPane(widget);
                scroll.setFitToWidth(true);
                scroll.setFitToHeight(true);
                widget = scroll;
            }
            return widget;
        }

        @Override
        protected GridPane createWidget() {
            GridPane p = new GridPane();
            return p;
        }

        public void updateLayout() {
        }
    }

    public static class WResizableSashImpl
    extends WLayoutedWidgetImpl<SplitPane, Node, MPartSashContainer>
    implements WSash<Node> {
        private List<WLayoutedWidget<MPartSashContainerElement>> items = new ArrayList<WLayoutedWidget<MPartSashContainerElement>>();
        ChangeListener<Number> listener = new ChangeListener<Number>(){
            boolean queueing;

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (!this.queueing) {
                    this.queueing = true;
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            this.recalcWeight();
                            queueing = false;
                        }
                    });
                }
            }
        };
        private final @NonNull MPartSashContainer domainElement;

        @Inject
        public WResizableSashImpl(@Named(value="fx.rendering.domElement") @NonNull MPartSashContainer domainElement) {
            this.domainElement = domainElement;
        }

        public void updateLayout() {
            this.updateDividers();
        }

        void recalcWeight() {
            @Nullable MPartSashContainer domElement = (MPartSashContainer)this.getDomElement();
            if (domElement != null) {
                BaseRenderer r = (BaseRenderer)domElement.getRenderer();
                r.syncUIModifications((MUIElement)domElement, this::doRecalcWeight);
            } else {
                this.logger.error("The domain object should not be null at this point");
            }
        }

        void doRecalcWeight() {
            if (this.state != WWidget.WidgetState.CREATED) {
                return;
            }
            double prev = 0.0;
            int idx = 0;
            if (this.items.isEmpty()) {
                return;
            }
            double[] dArray = ((SplitPane)this.getWidget()).getDividerPositions();
            int n = dArray.length;
            int n2 = 0;
            while (n2 < n) {
                MPartSashContainerElement element;
                double d = dArray[n2];
                if ((element = (MPartSashContainerElement)this.items.get(idx++).getDomElement()) != null) {
                    element.setContainerData("" + (d - prev) * 10.0);
                }
                prev = d;
                ++n2;
            }
            MPartSashContainerElement element = (MPartSashContainerElement)this.items.get(this.items.size() - 1).getDomElement();
            if (element != null) {
                element.setContainerData("" + (1.0 - prev) * 10.0);
            }
        }

        @Override
        protected void bindProperties(SplitPane widget) {
            super.bindProperties(widget);
            widget.getDividers().addListener((ListChangeListener)new ListChangeListener<SplitPane.Divider>(){

                public void onChanged(ListChangeListener.Change<? extends SplitPane.Divider> c) {
                    while (c.next()) {
                        for (SplitPane.Divider d : c.getAddedSubList()) {
                            if (d == null) continue;
                            d.positionProperty().addListener(listener);
                        }
                        for (SplitPane.Divider d : c.getRemoved()) {
                            if (d == null) continue;
                            d.positionProperty().removeListener(listener);
                        }
                    }
                }
            });
            for (SplitPane.Divider d : widget.getDividers()) {
                d.positionProperty().addListener(this.listener);
            }
        }

        @Override
        protected SplitPane createWidget() {
            SplitPane p = new SplitPane();
            return p;
        }

        @Inject
        void setOrientation(@Named(value="horizontal") boolean horizontal) {
            ((SplitPane)this.getWidget()).setOrientation(horizontal ? Orientation.HORIZONTAL : Orientation.VERTICAL);
        }

        @Override
        public Node getWidgetNode() {
            Node widget = (Node)this.getWidget();
            if (this.domainElement.getTags().contains("fx_scrollable")) {
                ScrollPane scroll = new ScrollPane(widget);
                scroll.setFitToWidth(true);
                scroll.setFitToHeight(true);
                widget = scroll;
            }
            return widget;
        }

        private static void setResizableWithParent(WLayoutedWidget widget) {
            MUIElement domElement = widget.getDomElement();
            if (domElement != null) {
                SplitPane.setResizableWithParent((Node)((Node)widget.getStaticLayoutNode()), (Boolean)(!domElement.getTags().contains("fx_no_auto_resize") ? 1 : 0));
            }
        }

        public void addItem(WLayoutedWidget<MPartSashContainerElement> widget) {
            SplitPane p = (SplitPane)this.getWidget();
            WResizableSashImpl.setResizableWithParent(widget);
            p.getItems().add((Object)((Node)widget.getStaticLayoutNode()));
            this.items.add(widget);
            this.updateDividers();
        }

        public void addItems(int index, List<WLayoutedWidget<MPartSashContainerElement>> list) {
            SplitPane p = (SplitPane)this.getWidget();
            ArrayList<Node> l = new ArrayList<Node>();
            for (WLayoutedWidget<MPartSashContainerElement> i : list) {
                WResizableSashImpl.setResizableWithParent(i);
                l.add((Node)i.getStaticLayoutNode());
            }
            p.getItems().addAll(index, l);
            this.items.addAll(index, list);
            this.updateDividers();
        }

        public void addItems(List<WLayoutedWidget<MPartSashContainerElement>> list) {
            SplitPane p = (SplitPane)this.getWidget();
            ArrayList<Node> l = new ArrayList<Node>();
            for (WLayoutedWidget<MPartSashContainerElement> i : list) {
                WResizableSashImpl.setResizableWithParent(i);
                l.add((Node)i.getStaticLayoutNode());
            }
            p.getItems().addAll(l);
            this.items.addAll(list);
            this.updateDividers();
        }

        @Override
        public void setWidgetState(WWidget.WidgetState state) {
            super.setWidgetState(state);
            if (state == WWidget.WidgetState.CREATED) {
                this.updateDividers();
            }
        }

        public void removeItem(WLayoutedWidget<MPartSashContainerElement> widget) {
            SplitPane p = (SplitPane)this.getWidget();
            p.getItems().remove(widget.getStaticLayoutNode());
            this.items.remove(widget);
            this.updateDividers();
        }

        @Override
        protected void doCleanup() {
            super.doCleanup();
            this.items.clear();
        }

        private void updateDividers() {
            if (this.items.size() <= 1) {
                return;
            }
            if (this.state != WWidget.WidgetState.CREATED) {
                return;
            }
            double total = 0.0;
            for (WLayoutedWidget<MPartSashContainerElement> w : this.items) {
                total += w.getWeight();
            }
            double[] deviders = new double[this.items.size() - 1];
            int i = 0;
            while (i < this.items.size() - 1) {
                deviders[i] = (i == 0 ? 0.0 : deviders[i - 1]) + this.items.get(i).getWeight() / total;
                ++i;
            }
            ((SplitPane)this.getWidget()).setDividerPositions(deviders);
        }

        public int getItemCount() {
            return ((SplitPane)this.getWidget()).getItems().size();
        }
    }

    public static class WResizableSashImpl_2
    extends WLayoutedWidgetImpl<SashPane, Node, MPartSashContainer>
    implements WSash<Node> {
        private List<WLayoutedWidget<?>> items = new ArrayList();
        private final @NonNull MPartSashContainer domainElement;

        @Inject
        public WResizableSashImpl_2(@Named(value="fx.rendering.domElement") @NonNull MPartSashContainer domainElement) {
            this.domainElement = domainElement;
        }

        public int getItemCount() {
            SashPane p = (SashPane)this.getWidget();
            return p.getItems().size();
        }

        private static int getWeight(WLayoutedWidget<?> w) {
            double v = w.getWeight();
            MUIElement domElement = w.getDomElement();
            if (v < 1.0) {
                return (int)(v * 100.0);
            }
            if (domElement == null || domElement.getContainerData() == null) {
                return 200;
            }
            return (int)v;
        }

        public void addItem(@NonNull WLayoutedWidget<MPartSashContainerElement> widget) {
            this.syncWeights();
            SashPane p = (SashPane)this.getWidget();
            int[] w = p.getWeights();
            p.getItems().add((Object)((Node)widget.getStaticLayoutNode()));
            int[] wn = new int[w.length + 1];
            System.arraycopy(w, 0, wn, 0, w.length);
            wn[wn.length - 1] = WResizableSashImpl_2.getWeight(widget);
            p.setWeights(wn);
            this.items.add(widget);
        }

        public void addItems(@NonNull List<WLayoutedWidget<MPartSashContainerElement>> list) {
            this.syncWeights();
            SashPane p = (SashPane)this.getWidget();
            int[] w = p.getWeights();
            p.getItems().addAll((Collection)list.stream().map(e -> (Node)e.getStaticLayoutNode()).collect(Collectors.toList()));
            int[] wn = new int[w.length + list.size()];
            System.arraycopy(w, 0, wn, 0, w.length);
            int i = w.length;
            while (i < wn.length) {
                wn[i] = WResizableSashImpl_2.getWeight(list.get(i - w.length));
                ++i;
            }
            p.setWeights(wn);
            this.items.addAll(list);
        }

        public void addItems(int index, @NonNull List<WLayoutedWidget<MPartSashContainerElement>> list) {
            this.syncWeights();
            SashPane p = (SashPane)this.getWidget();
            int[] w = p.getWeights();
            p.getItems().addAll(index, (Collection)list.stream().map(e -> (Node)e.getStaticLayoutNode()).collect(Collectors.toList()));
            int[] wn = new int[w.length + list.size()];
            System.arraycopy(w, 0, wn, 0, index);
            int i = 0;
            while (i < list.size()) {
                wn[i + index] = WResizableSashImpl_2.getWeight(list.get(i));
                ++i;
            }
            System.arraycopy(w, index, wn, index + 1, w.length - index);
            p.setWeights(wn);
            this.items.addAll(index, list);
        }

        public void removeItem(@NonNull WLayoutedWidget<MPartSashContainerElement> widget) {
            this.syncWeights();
            SashPane p = (SashPane)this.getWidget();
            p.getItems().remove(widget.getStaticLayoutNode());
            this.items.remove(widget);
        }

        public void updateLayout() {
        }

        private void syncWeights() {
            int[] weights = ((SashPane)this.getWidget()).getWeights();
            int i = 0;
            while (i < weights.length) {
                MUIElement domElement = this.items.get(i).getDomElement();
                if (domElement != null) {
                    domElement.setContainerData("" + weights[i]);
                }
                ++i;
            }
        }

        @Override
        public @NonNull Node getWidgetNode() {
            Node widget = (Node)this.getWidget();
            if (this.domainElement.getTags().contains("fx_scrollable")) {
                ScrollPane scroll = new ScrollPane(widget);
                scroll.setFitToWidth(true);
                scroll.setFitToHeight(true);
                widget = scroll;
            }
            return widget;
        }

        @Override
        protected @NonNull SashPane createWidget() {
            SashPane p = new SashPane();
            p.weightsProperty().addListener((ob, ol, ne) -> this.handleWeightsChanged((int[])ne));
            return p;
        }

        private void handleWeightsChanged(int[] ne) {
            this.syncWeights();
        }

        @Inject
        void setOrientation(@Named(value="horizontal") boolean horizontal) {
            ((SashPane)this.getWidget()).setHorizontal(horizontal);
        }
    }
}

