/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.di.context;

import java.util.Optional;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.fx.core.ObjectFactoryService;
import org.eclipse.fx.core.RankedObjectRegistry;
import org.eclipse.fx.core.di.context.ServiceContextFunction;

public abstract class ServiceFactoryContextFunction<S, T, O extends ObjectFactoryService<S, T>>
extends ServiceContextFunction<O> {
    private String selectorTypeKey;

    protected ServiceFactoryContextFunction(String selectorTypeKey) {
        this.selectorTypeKey = selectorTypeKey;
    }

    protected String getCacheKey() {
        return "__cached_type_" + ((Object)((Object)this)).getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object compute(IEclipseContext context) {
        Optional<Object> value;
        String cacheKey = this.getCacheKey();
        Object o = context.get(cacheKey);
        if (o != null) {
            return o;
        }
        Object sourceValue = context.get(this.selectorTypeKey);
        RankedObjectRegistry rankedObjectRegistry = this.registry;
        synchronized (rankedObjectRegistry) {
            value = this.registry.unsynchronizedStream().filter(d -> d.test(sourceValue)).findFirst().map(d -> d.create(sourceValue));
        }
        if (value.isPresent()) {
            o = value.get();
            context.set(cacheKey, o);
            return o;
        }
        throw new IllegalStateException("Unable to find a service factory for the source value '" + String.valueOf(sourceValue) + "'");
    }

    public final Object compute(IEclipseContext context, String contextKey) {
        return super.compute(context, contextKey);
    }
}

