/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.array;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;

public class ArrayUtils {
    public static <T> void fill(T[] array, Supplier<T> s) {
        int i = 0;
        while (i < array.length) {
            array[i] = s.get();
            ++i;
        }
    }

    public static <T> void fill(T[] array, IntFunction<T> f) {
        int i = 0;
        while (i < array.length) {
            array[i] = f.apply(i);
            ++i;
        }
    }

    public static <T> void toString(T[][] array) {
        System.err.println("---------------");
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[i].length) {
                System.err.print(array[i][j] == null ? " - " : " x ");
                ++j;
            }
            System.err.println();
            ++i;
        }
        System.err.println("---------------");
    }

    public static Map<String, Object> toMap(String ... args) {
        HashMap<String, Object> rv = new HashMap<String, Object>();
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-")) {
                ArrayList<String> l = new ArrayList<String>();
                String key = args[i].substring(1);
                if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                    do {
                        l.add(args[++i]);
                    } while (i + 1 < args.length && !args[i + 1].startsWith("-"));
                    if (l.size() == 1) {
                        rv.put(key, l.get(0));
                    } else {
                        rv.put(key, l);
                    }
                } else {
                    rv.put(args[i].substring(1), Boolean.TRUE);
                }
            }
            ++i;
        }
        return rv;
    }

    public static IntStream stream(final char[] content, int startInclusive, final int endExclusive) {
        PrimitiveIterator.OfInt ofInt = new PrimitiveIterator.OfInt(startInclusive){
            int cur;
            {
                this.cur = n;
            }

            @Override
            public boolean hasNext() {
                return this.cur < endExclusive;
            }

            @Override
            public int nextInt() {
                if (this.hasNext()) {
                    return content[this.cur];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void forEachRemaining(IntConsumer action) {
                while (this.cur < endExclusive) {
                    action.accept(content[this.cur]);
                    ++this.cur;
                }
            }
        };
        return StreamSupport.intStream(() -> Spliterators.spliterator(ofInt, (long)(endExclusive - startInclusive), 16), 16464, false);
    }

    public static <T> T[] createArray1Dim(Class<T> elementType, int length) {
        return (Object[])Array.newInstance(elementType, length);
    }

    public static <T> T[][] createArray2Dim(Class<T> elementType, int lengthLevel1, int lengthLevel2) {
        return (Object[][])Array.newInstance(elementType, lengthLevel1, lengthLevel2);
    }

    public static <T> T[][] createArray2Dim(Class<T> elementType, int lengthLevel1) {
        return ArrayUtils.createArray2Dim(elementType, lengthLevel1, 0);
    }
}

