/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.tree;

import java.util.Comparator;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.transformation.SortedList;
import javafx.scene.control.TreeItem;
import org.eclipse.fx.ui.controls.tree.FilterableTreeItem;
import org.eclipse.fx.ui.controls.tree.TreeItemComparator;

public class SortableTreeItem<T>
extends FilterableTreeItem<T> {
    private final SortedList<TreeItem<T>> sortedList;
    private ObjectProperty<TreeItemComparator<T>> comparator = new SimpleObjectProperty();

    public SortableTreeItem(T value) {
        super(value);
        this.sortedList = new SortedList(super.getChildren());
        this.sortedList.comparatorProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            if (this.comparator.get() == null) {
                return null;
            }
            Comparator cp = (o1, o2) -> ((TreeItemComparator)this.comparator.get()).compare(this, o1.getValue(), o2.getValue());
            return cp;
        }, (Observable[])new Observable[]{this.comparator}));
        this.parentProperty().addListener((o, oV, nV) -> {
            if (nV != null && nV instanceof SortableTreeItem && this.comparator.get() == null) {
                this.comparator.bind(((SortableTreeItem)((Object)nV)).comparatorProperty());
            }
        });
        this.setHiddenFieldChildren(this.sortedList);
    }

    public final ObjectProperty<TreeItemComparator<T>> comparatorProperty() {
        return this.comparator;
    }

    public final TreeItemComparator<T> getComparator() {
        return (TreeItemComparator)this.comparator.get();
    }

    public final void setComparator(TreeItemComparator<T> comparator) {
        this.comparator.set(comparator);
    }
}

