/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.tabpane.skin;

import com.sun.javafx.scene.control.skin.TabPaneSkin;
import java.lang.reflect.Field;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.animation.ScaleTransition;
import javafx.css.StyleOrigin;
import javafx.css.StyleableProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.util.Duration;
import org.eclipse.fx.ui.controls.Util;
import org.eclipse.fx.ui.controls.dnd.EFXDragEvent;
import org.eclipse.fx.ui.controls.tabpane.DndTabPaneFactory;
import org.eclipse.fx.ui.controls.tabpane.GenericTab;
import org.eclipse.fx.ui.controls.tabpane.skin.FXTabWrapper;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DnDTabPaneSkinFullDrag
extends TabPaneSkin
implements DndTabPaneFactory.DragSetup {
    private static Tab DRAGGED_TAB;
    private Object noneEnum;
    private StyleableProperty<Object> openAnimation;
    private StyleableProperty<Object> closeAnimation;
    private @Nullable Function<@NonNull GenericTab, @NonNull Boolean> startFunction;
    private @Nullable Consumer<@NonNull GenericTab> dragFinishedConsumer;
    private @Nullable Consumer< @NonNull DndTabPaneFactory.FeedbackData> feedbackConsumer;
    private @Nullable Consumer< @NonNull DndTabPaneFactory.DroppedData> dropConsumer;
    private @Nullable Function<@NonNull GenericTab, @NonNull String> clipboardDataFunction;

    public DnDTabPaneSkinFullDrag(TabPane tabPane) {
        super(tabPane);
        this.hookTabFolderSkin();
    }

    private void hookTabFolderSkin() {
        block7: {
            try {
                Field f_tabHeaderArea = TabPaneSkin.class.getDeclaredField("tabHeaderArea");
                f_tabHeaderArea.setAccessible(true);
                StackPane tabHeaderArea = (StackPane)f_tabHeaderArea.get(this);
                tabHeaderArea.setOnDragOver(e -> e.consume());
                Field f_headersRegion = tabHeaderArea.getClass().getDeclaredField("headersRegion");
                f_headersRegion.setAccessible(true);
                StackPane headersRegion = (StackPane)f_headersRegion.get(tabHeaderArea);
                EventHandler handler = this::tabPane_handleDragStart;
                EventHandler handlerFinished = this::tabPane_handleDragDone;
                EventHandler handle_mouseDragged = this::handle_mouseDragged;
                EventHandler handleMouseReleased = this::handleMouseReleased;
                for (Node tabHeaderSkin : headersRegion.getChildren()) {
                    tabHeaderSkin.addEventHandler(MouseEvent.DRAG_DETECTED, handler);
                    tabHeaderSkin.addEventHandler(MouseEvent.MOUSE_DRAGGED, handle_mouseDragged);
                    tabHeaderSkin.addEventHandler(MouseEvent.MOUSE_RELEASED, handleMouseReleased);
                    tabHeaderSkin.addEventHandler(EFXDragEvent.DRAG_DONE, handlerFinished);
                }
                headersRegion.getChildren().addListener(change -> {
                    while (change.next()) {
                        if (change.wasRemoved()) {
                            change.getRemoved().forEach(e -> e.removeEventHandler(MouseEvent.DRAG_DETECTED, handler));
                            change.getRemoved().forEach(e -> e.removeEventHandler(MouseEvent.MOUSE_DRAGGED, handle_mouseDragged));
                            change.getRemoved().forEach(e -> e.removeEventHandler(MouseEvent.MOUSE_RELEASED, handleMouseReleased));
                        }
                        if (!change.wasAdded()) continue;
                        change.getAddedSubList().forEach(e -> e.addEventHandler(MouseEvent.DRAG_DETECTED, handler));
                        change.getAddedSubList().forEach(e -> e.addEventHandler(MouseEvent.MOUSE_DRAGGED, handle_mouseDragged));
                        change.getAddedSubList().forEach(e -> e.addEventHandler(MouseEvent.MOUSE_RELEASED, handleMouseReleased));
                    }
                });
                tabHeaderArea.addEventHandler(EFXDragEvent.DRAG_OVER, arg_0 -> this.lambda$2((Pane)tabHeaderArea, (Pane)headersRegion, arg_0));
                tabHeaderArea.addEventHandler(EFXDragEvent.DRAG_DROPPED, arg_0 -> this.lambda$3((Pane)tabHeaderArea, (Pane)headersRegion, arg_0));
                Field field = TabPaneSkin.class.getDeclaredField("openTabAnimation");
                field.setAccessible(true);
                this.openAnimation = (StyleableProperty)field.get(this);
                field = TabPaneSkin.class.getDeclaredField("closeTabAnimation");
                field.setAccessible(true);
                this.closeAnimation = (StyleableProperty)field.get(this);
                Class<?>[] classArray = this.getClass().getDeclaredClasses();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> cl = classArray[n2];
                    if ("TabAnimation".equals(cl.getSimpleName())) {
                        Enum[] enumArray = (Enum[])cl.getEnumConstants();
                        int n3 = enumArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Enum enumConstant = enumArray[n4];
                            if ("NONE".equals(enumConstant.name())) {
                                this.noneEnum = enumConstant;
                                break block7;
                            }
                            ++n4;
                        }
                        break;
                    }
                    ++n2;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        ((TabPane)this.getSkinnable()).addEventHandler(EFXDragEvent.DRAG_DONE, this::tabPane_handleDragDone);
    }

    void handle_mouseDragged(MouseEvent e) {
        if (DRAGGED_TAB == null) {
            return;
        }
        Node node = Util.findNode(null, e.getScreenX(), e.getScreenY());
        if (node != null) {
            ((Stage)node.getScene().getWindow()).toFront();
            Event.fireEvent((EventTarget)node, (Event)new EFXDragEvent(this, (EventTarget)node, EFXDragEvent.DRAG_OVER, e.getScreenX(), e.getScreenY(), false));
        } else {
            EFXDragEvent.updateFeedbackLocation(e.getScreenX(), e.getScreenY());
        }
    }

    private void handleMouseReleased(MouseEvent e) {
        if (DRAGGED_TAB == null) {
            return;
        }
        boolean isComplete = false;
        try {
            Node node = Util.findNode(null, e.getScreenX(), e.getScreenY());
            if (node != null) {
                EFXDragEvent event = new EFXDragEvent(node, (EventTarget)node, EFXDragEvent.DRAG_DROPPED, e.getScreenX(), e.getScreenY(), false);
                Event.fireEvent((EventTarget)node, (Event)event);
                isComplete = event.isComplete();
            } else {
                this.efx_dropped(e.getScreenX(), e.getScreenY(), FXTabWrapper.wrap(DRAGGED_TAB), null, DndTabPaneFactory.DropType.DETACH);
            }
        }
        finally {
            Event.fireEvent((EventTarget)this.getSkinnable(), (Event)new EFXDragEvent(this.getSkinnable(), (EventTarget)this.getSkinnable(), EFXDragEvent.DRAG_DONE, e.getScreenX(), e.getScreenY(), isComplete));
            DRAGGED_TAB = null;
        }
    }

    void tabPane_handleDragStart(MouseEvent event) {
        try {
            Field f_tab = event.getSource().getClass().getDeclaredField("tab");
            f_tab.setAccessible(true);
            Tab t = (Tab)f_tab.get(event.getSource());
            if (t != null && this.efx_canStartDrag(FXTabWrapper.wrap(t))) {
                DRAGGED_TAB = t;
                Node n = (Node)event.getSource();
                n.startFullDrag();
                String data = this.efx_getClipboardContent(FXTabWrapper.wrap(t));
                EFXDragEvent evt = new EFXDragEvent(event.getSource(), event.getTarget(), EFXDragEvent.DRAG_START, event.getScreenX(), event.getScreenY(), false);
                evt.setDraggedContent(data);
                evt.updateFeedback(p -> {
                    SnapshotParameters snapshotParameters = new SnapshotParameters();
                    snapshotParameters.setFill((Paint)Color.TRANSPARENT);
                    WritableImage snapShot = n.snapshot(snapshotParameters, null);
                    ImageView v = new ImageView((Image)snapShot);
                    ScaleTransition st = new ScaleTransition(Duration.millis((double)200.0), (Node)v);
                    st.setFromX(0.0);
                    st.setToX(1.0);
                    st.play();
                    p.getChildren().add((Object)v);
                });
                Event.fireEvent((EventTarget)event.getTarget(), (Event)evt);
                event.consume();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    void tabPane_handleDragOver(Pane tabHeaderArea, Pane headersRegion, EFXDragEvent event) {
        Tab draggedTab = DRAGGED_TAB;
        if (draggedTab == null) {
            return;
        }
        event.consume();
        double x = event.getX() - headersRegion.getBoundsInParent().getMinX();
        Object referenceNode = null;
        DndTabPaneFactory.DropType type = DndTabPaneFactory.DropType.AFTER;
        for (Node n : headersRegion.getChildren()) {
            Bounds b = n.getBoundsInParent();
            if (!(b.getMaxX() > x)) continue;
            if (b.getMinX() + b.getWidth() / 2.0 > x) {
                referenceNode = n;
                type = DndTabPaneFactory.DropType.BEFORE;
                break;
            }
            referenceNode = n;
            type = DndTabPaneFactory.DropType.AFTER;
            break;
        }
        if (referenceNode == null && headersRegion.getChildren().size() > 0) {
            referenceNode = (Node)headersRegion.getChildren().get(headersRegion.getChildren().size() - 1);
            type = DndTabPaneFactory.DropType.AFTER;
        }
        if (referenceNode != null) {
            try {
                int idx;
                Field field = referenceNode.getClass().getDeclaredField("tab");
                field.setAccessible(true);
                Tab tab = (Tab)field.get(referenceNode);
                boolean noMove = false;
                if (tab == draggedTab) {
                    noMove = true;
                } else if (type == DndTabPaneFactory.DropType.BEFORE) {
                    idx = ((TabPane)this.getSkinnable()).getTabs().indexOf((Object)tab);
                    if (idx > 0 && ((TabPane)this.getSkinnable()).getTabs().get(idx - 1) == draggedTab) {
                        noMove = true;
                    }
                } else {
                    idx = ((TabPane)this.getSkinnable()).getTabs().indexOf((Object)tab);
                    if (idx + 1 < ((TabPane)this.getSkinnable()).getTabs().size() && ((TabPane)this.getSkinnable()).getTabs().get(idx + 1) == draggedTab) {
                        noMove = true;
                    }
                }
                if (noMove) {
                    this.efx_dragFeedback(FXTabWrapper.wrap(draggedTab), null, null, DndTabPaneFactory.DropType.NONE);
                    return;
                }
                Bounds b = referenceNode.getBoundsInLocal();
                b = referenceNode.localToScene(b);
                b = ((TabPane)this.getSkinnable()).sceneToLocal(b);
                this.efx_dragFeedback(FXTabWrapper.wrap(draggedTab), FXTabWrapper.wrap(tab), b, type);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            this.efx_dragFeedback(FXTabWrapper.wrap(draggedTab), null, null, DndTabPaneFactory.DropType.NONE);
        }
    }

    void tabPane_handleDragDropped(Pane tabHeaderArea, Pane headersRegion, EFXDragEvent event) {
        Tab draggedTab = DRAGGED_TAB;
        if (draggedTab == null) {
            return;
        }
        double x = event.getX() - headersRegion.getBoundsInParent().getMinX();
        Object referenceNode = null;
        DndTabPaneFactory.DropType type = DndTabPaneFactory.DropType.AFTER;
        for (Node n : headersRegion.getChildren()) {
            Bounds b = n.getBoundsInParent();
            if (!(b.getMaxX() > x)) continue;
            if (b.getMinX() + b.getWidth() / 2.0 > x) {
                referenceNode = n;
                type = DndTabPaneFactory.DropType.BEFORE;
                break;
            }
            referenceNode = n;
            type = DndTabPaneFactory.DropType.AFTER;
            break;
        }
        if (referenceNode == null && headersRegion.getChildren().size() > 0) {
            referenceNode = (Node)headersRegion.getChildren().get(headersRegion.getChildren().size() - 1);
            type = DndTabPaneFactory.DropType.AFTER;
        }
        if (referenceNode != null) {
            block18: {
                try {
                    int idx;
                    Field field = referenceNode.getClass().getDeclaredField("tab");
                    field.setAccessible(true);
                    Tab tab = (Tab)field.get(referenceNode);
                    boolean noMove = false;
                    if (tab == null) {
                        event.setComplete(false);
                        return;
                    }
                    if (tab == draggedTab) {
                        noMove = true;
                    } else if (type == DndTabPaneFactory.DropType.BEFORE) {
                        idx = ((TabPane)this.getSkinnable()).getTabs().indexOf((Object)tab);
                        if (idx > 0 && ((TabPane)this.getSkinnable()).getTabs().get(idx - 1) == draggedTab) {
                            noMove = true;
                        }
                    } else {
                        idx = ((TabPane)this.getSkinnable()).getTabs().indexOf((Object)tab);
                        if (idx + 1 < ((TabPane)this.getSkinnable()).getTabs().size() && ((TabPane)this.getSkinnable()).getTabs().get(idx + 1) == draggedTab) {
                            noMove = true;
                        }
                    }
                    if (!noMove) {
                        StyleOrigin openOrigin = this.openAnimation.getStyleOrigin();
                        StyleOrigin closeOrigin = this.closeAnimation.getStyleOrigin();
                        Object openValue = this.openAnimation.getValue();
                        Object closeValue = this.closeAnimation.getValue();
                        try {
                            this.openAnimation.setValue(this.noneEnum);
                            this.closeAnimation.setValue(this.noneEnum);
                            this.efx_dropped(event.getScreenX(), event.getScreenY(), FXTabWrapper.wrap(draggedTab), FXTabWrapper.wrap(tab), type);
                            event.setComplete(true);
                            break block18;
                        }
                        finally {
                            this.openAnimation.applyStyle(openOrigin, openValue);
                            this.closeAnimation.applyStyle(closeOrigin, closeValue);
                        }
                    }
                    event.setComplete(false);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            event.consume();
        }
    }

    void tabPane_handleDragDone(EFXDragEvent event) {
        Tab tab = DRAGGED_TAB;
        if (tab == null) {
            return;
        }
        this.efx_dragFinished(FXTabWrapper.wrap(tab));
    }

    @Override
    public void setClipboardDataFunction(@Nullable Function<@NonNull GenericTab, @NonNull String> clipboardDataFunction) {
        this.clipboardDataFunction = clipboardDataFunction;
    }

    @Override
    public void setStartFunction(@Nullable Function<@NonNull GenericTab, @NonNull Boolean> startFunction) {
        this.startFunction = startFunction;
    }

    @Override
    public void setDragFinishedConsumer(@Nullable Consumer<@NonNull GenericTab> dragFinishedConsumer) {
        this.dragFinishedConsumer = dragFinishedConsumer;
    }

    @Override
    public void setFeedbackConsumer(@Nullable Consumer< @NonNull DndTabPaneFactory.FeedbackData> feedbackConsumer) {
        this.feedbackConsumer = feedbackConsumer;
    }

    @Override
    public void setDropConsumer(@Nullable Consumer< @NonNull DndTabPaneFactory.DroppedData> dropConsumer) {
        this.dropConsumer = dropConsumer;
    }

    private boolean efx_canStartDrag(@NonNull GenericTab tab) {
        if (this.startFunction != null) {
            return this.startFunction.apply(tab);
        }
        return true;
    }

    private void efx_dragFeedback(@NonNull GenericTab draggedTab, GenericTab targetTab, Bounds bounds,  @NonNull DndTabPaneFactory.DropType dropType) {
        if (this.feedbackConsumer != null) {
            this.feedbackConsumer.accept(new DndTabPaneFactory.FeedbackData(draggedTab, targetTab, bounds, dropType));
        }
    }

    private void efx_dropped(double x, double y, @NonNull GenericTab draggedTab, @Nullable GenericTab targetTab,  @NonNull DndTabPaneFactory.DropType dropType) {
        if (this.dropConsumer != null) {
            this.dropConsumer.accept(new DndTabPaneFactory.DroppedData(x, y, draggedTab, targetTab, dropType));
        }
    }

    private void efx_dragFinished(@NonNull GenericTab tab) {
        if (this.dragFinishedConsumer != null) {
            this.dragFinishedConsumer.accept(tab);
        }
    }

    private String efx_getClipboardContent(@NonNull GenericTab t) {
        if (this.clipboardDataFunction != null) {
            return this.clipboardDataFunction.apply(t);
        }
        return String.valueOf(System.identityHashCode(t));
    }

    private /* synthetic */ void lambda$2(Pane pane, Pane pane2, EFXDragEvent e) {
        this.tabPane_handleDragOver(pane, pane2, e);
    }

    private /* synthetic */ void lambda$3(Pane pane, Pane pane2, EFXDragEvent e) {
        this.tabPane_handleDragDropped(pane, pane2, e);
    }
}

