/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractRootedReentrantTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.CompoundReentrantTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.IReentrantTypeResolver;

public class DefaultBatchTypeResolver
extends AbstractBatchTypeResolver {
    @Inject
    private Provider<AbstractRootedReentrantTypeResolver> typeResolverProvider;

    @Override
    protected IResolvedTypes doResolveTypes(EObject object, CancelIndicator monitor) {
        Resource resource = object.eResource();
        if (resource instanceof StorageAwareResource && ((StorageAwareResource)resource).isLoadedFromStorage()) {
            throw new IllegalStateException("Type resolution is not supported on a storage-loaded resource : " + resource.getURI());
        }
        EObject nonArtificialObject = this.getNonArtificialObject(object);
        IReentrantTypeResolver reentrantResolver = this.getTypeResolver(nonArtificialObject);
        return reentrantResolver.reentrantResolve(monitor == null ? CancelIndicator.NullImpl : monitor);
    }

    private EObject getNonArtificialObject(EObject object) {
        EObject nonArtificialObject = object;
        if (object.eResource() == null && object instanceof XAbstractFeatureCall) {
            nonArtificialObject = ((XAbstractFeatureCall)object).getFeature();
        }
        return nonArtificialObject;
    }

    protected IReentrantTypeResolver getTypeResolver(EObject object) {
        HashSet allRootedExpressions = Sets.newHashSet();
        List<EObject> roots = this.getEntryPoints(object);
        if (roots.size() == 1) {
            AbstractRootedReentrantTypeResolver result = this.createResolver(roots.get(0));
            result.setAllRootedExpressions(allRootedExpressions);
            return result;
        }
        if (roots.isEmpty()) {
            return IReentrantTypeResolver.NULL;
        }
        CompoundReentrantTypeResolver result = new CompoundReentrantTypeResolver(allRootedExpressions);
        for (EObject root : roots) {
            AbstractRootedReentrantTypeResolver resolver = this.createResolver(root);
            result.addResolver(resolver);
        }
        return result;
    }

    protected List<EObject> getEntryPoints(EObject object) {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)object);
        if (rootContainer instanceof XExpression) {
            return Collections.singletonList(rootContainer);
        }
        return Collections.emptyList();
    }

    protected AbstractRootedReentrantTypeResolver createResolver(EObject root) {
        AbstractRootedReentrantTypeResolver resolver = this.createResolver();
        resolver.initializeFrom(root);
        return resolver;
    }

    protected AbstractRootedReentrantTypeResolver createResolver() {
        return (AbstractRootedReentrantTypeResolver)this.typeResolverProvider.get();
    }
}

