/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.tree;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.control.TreeItem;
import org.eclipse.fx.ui.controls.tree.TreeItemPredicate;

public class FilterableTreeItem<T>
extends TreeItem<T> {
    private final FilteredList<TreeItem<T>> filteredList;
    private ObjectProperty<TreeItemPredicate<T>> predicate = new SimpleObjectProperty<TreeItemPredicate<T>>(){

        protected void invalidated() {
            FilterableTreeItem.this.fireChildrenModificationEvent();
        }
    };

    public FilterableTreeItem(T value) {
        super(value);
        this.filteredList = new FilteredList(super.getChildren());
        this.filteredList.predicateProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> child -> {
            if (child instanceof FilterableTreeItem) {
                FilterableTreeItem filterableChild = (FilterableTreeItem)((Object)((Object)child));
                filterableChild.setPredicate((TreeItemPredicate)this.predicate.get());
            }
            if (this.predicate.get() == null) {
                return true;
            }
            if (child.getChildren().size() > 0) {
                return true;
            }
            return ((TreeItemPredicate)this.predicate.get()).test(this, child.getValue());
        }, (Observable[])new Observable[]{this.predicate}));
    }

    public ObservableList<TreeItem<T>> getChildren() {
        return this.filteredList;
    }

    public ObservableList<TreeItem<T>> getInternalChildren() {
        return super.getChildren();
    }

    void fireChildrenModificationEvent() {
        TreeItem.TreeModificationEvent event = new TreeItem.TreeModificationEvent(TreeItem.childrenModificationEvent(), (TreeItem)this);
        Event.fireEvent((EventTarget)this, (Event)event);
    }

    public boolean isLeaf() {
        return this.getChildren().isEmpty();
    }

    public final ObjectProperty<TreeItemPredicate<T>> predicateProperty() {
        return this.predicate;
    }

    public final TreeItemPredicate<T> getPredicate() {
        return (TreeItemPredicate)this.predicate.get();
    }

    public final void setPredicate(TreeItemPredicate<T> predicate) {
        this.predicate.set(predicate);
    }
}

