/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.servlet;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.equinox.http.servlet.internal.context.DispatchTargets;
import org.eclipse.equinox.http.servlet.internal.registration.EndpointRegistration;
import org.eclipse.equinox.http.servlet.internal.servlet.RequestDispatcherAdaptor;
import org.eclipse.equinox.http.servlet.internal.util.EventListeners;

public class HttpServletRequestBuilder {
    private DispatchTargets dispatchTargets;
    private EndpointRegistration<?> servletRegistration;
    private final HttpServletRequest request;
    private HttpServletRequest requestProxy;
    private boolean isRequestDispatcherInclude;
    static final String INCLUDE_REQUEST_URI_ATTRIBUTE = "javax.servlet.include.request_uri";
    static final String INCLUDE_CONTEXT_PATH_ATTRIBUTE = "javax.servlet.include.context_path";
    static final String INCLUDE_SERVLET_PATH_ATTRIBUTE = "javax.servlet.include.servlet_path";
    static final String INCLUDE_PATH_INFO_ATTRIBUTE = "javax.servlet.include.path_info";
    private final ThreadLocal<HttpServletRequest> requestTL = new ThreadLocal();
    private static final Map<Method, Method> requestToHandlerMethods = HttpServletRequestBuilder.createContextToHandlerMethods();

    private static Map<Method, Method> createContextToHandlerMethods() {
        HashMap<Method, Method> methods = new HashMap<Method, Method>();
        Method[] handlerMethods = HttpServletRequestBuilder.class.getDeclaredMethods();
        int i = 0;
        while (i < handlerMethods.length) {
            Method handlerMethod = handlerMethods[i];
            String name = handlerMethod.getName();
            Class<?>[] parameterTypes = handlerMethod.getParameterTypes();
            try {
                Method method = HttpServletRequest.class.getMethod(name, parameterTypes);
                methods.put(method, handlerMethod);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            ++i;
        }
        return methods;
    }

    public HttpServletRequestBuilder(HttpServletRequest request, DispatchTargets dispatchTargets) {
        this.request = request;
        this.dispatchTargets = dispatchTargets;
        this.servletRegistration = dispatchTargets.getServletRegistration();
        this.isRequestDispatcherInclude = request.getAttribute(INCLUDE_REQUEST_URI_ATTRIBUTE) != null;
        this.requestProxy = (HttpServletRequest)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{HttpServletRequest.class, RequestGetter.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("getOriginalRequest")) {
                    return HttpServletRequestBuilder.this.getOriginalRequest();
                }
                return HttpServletRequestBuilder.this.invoke(proxy, method, args);
            }
        });
    }

    public HttpServletRequest build() {
        return this.requestProxy;
    }

    Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.requestTL.set((HttpServletRequest)proxy);
        try {
            block7: {
                Method m = requestToHandlerMethods.get(method);
                try {
                    if (m == null) break block7;
                    Object object = m.invoke((Object)this, args);
                    return object;
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            Object object = method.invoke((Object)this.request, args);
            return object;
        }
        finally {
            this.requestTL.remove();
        }
    }

    public String getAuthType() {
        String authType = (String)this.request.getAttribute("org.osgi.service.http.authentication.type");
        if (authType != null) {
            return authType;
        }
        return this.request.getAuthType();
    }

    public String getRemoteUser() {
        String remoteUser = (String)this.request.getAttribute("org.osgi.service.http.authentication.remote.user");
        if (remoteUser != null) {
            return remoteUser;
        }
        return this.request.getRemoteUser();
    }

    public String getPathInfo() {
        if (this.isRequestDispatcherInclude) {
            return this.request.getPathInfo();
        }
        return this.dispatchTargets.getPathInfo();
    }

    public ServletContext getServletContext() {
        return this.servletRegistration.getServletContext();
    }

    public String getServletPath() {
        if (this.isRequestDispatcherInclude) {
            return this.request.getServletPath();
        }
        if (this.dispatchTargets.getServletPath().equals("/")) {
            return "";
        }
        return this.dispatchTargets.getServletPath();
    }

    public String getContextPath() {
        return this.dispatchTargets.getContextController().getFullContextPath();
    }

    public Object getAttribute(String attributeName) {
        String servletPath = this.dispatchTargets.getServletPath();
        if (this.isRequestDispatcherInclude) {
            if (attributeName.equals(INCLUDE_CONTEXT_PATH_ATTRIBUTE)) {
                String includeServletPath;
                String contextPath = (String)this.request.getAttribute(INCLUDE_CONTEXT_PATH_ATTRIBUTE);
                if (contextPath == null || contextPath.equals("/")) {
                    contextPath = "";
                }
                if ((includeServletPath = (String)this.request.getAttribute(INCLUDE_SERVLET_PATH_ATTRIBUTE)) == null || includeServletPath.equals("/")) {
                    includeServletPath = "";
                }
                return String.valueOf(contextPath) + includeServletPath;
            }
            if (attributeName.equals(INCLUDE_SERVLET_PATH_ATTRIBUTE)) {
                if (servletPath.equals("/")) {
                    return "";
                }
                return servletPath;
            }
            if (attributeName.equals(INCLUDE_PATH_INFO_ATTRIBUTE)) {
                String pathInfoAttribute = (String)this.request.getAttribute(INCLUDE_PATH_INFO_ATTRIBUTE);
                if (servletPath.equals("/")) {
                    return pathInfoAttribute;
                }
                if (pathInfoAttribute == null || pathInfoAttribute.length() == 0) {
                    return null;
                }
                if (pathInfoAttribute.startsWith(servletPath)) {
                    pathInfoAttribute = pathInfoAttribute.substring(servletPath.length());
                }
                if (pathInfoAttribute.length() == 0) {
                    return null;
                }
                return pathInfoAttribute;
            }
        }
        return this.request.getAttribute(attributeName);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (!path.startsWith(this.getContextPath())) {
            path = this.getContextPath().substring(this.request.getContextPath().length()).concat(path);
        }
        return new RequestDispatcherAdaptor(this.request.getRequestDispatcher(path));
    }

    public static String getDispatchPathInfo(HttpServletRequest req) {
        if (req.getAttribute(INCLUDE_REQUEST_URI_ATTRIBUTE) != null) {
            return (String)req.getAttribute(INCLUDE_PATH_INFO_ATTRIBUTE);
        }
        return req.getPathInfo();
    }

    public static String getDispatchServletPath(HttpServletRequest req) {
        if (req.getAttribute(INCLUDE_REQUEST_URI_ATTRIBUTE) != null) {
            String servletPath = (String)req.getAttribute(INCLUDE_SERVLET_PATH_ATTRIBUTE);
            return servletPath == null ? "" : servletPath;
        }
        return req.getServletPath();
    }

    public HttpSession getSession() {
        HttpSession session = this.request.getSession();
        if (session != null) {
            return this.dispatchTargets.getContextController().getSessionAdaptor(session, ((Servlet)this.servletRegistration.getT()).getServletConfig().getServletContext());
        }
        return null;
    }

    public HttpSession getSession(boolean create) {
        HttpSession session = this.request.getSession(create);
        if (session != null) {
            return this.dispatchTargets.getContextController().getSessionAdaptor(session, ((Servlet)this.servletRegistration.getT()).getServletConfig().getServletContext());
        }
        return null;
    }

    public void removeAttribute(String name) {
        this.request.removeAttribute(name);
        EventListeners eventListeners = this.dispatchTargets.getContextController().getEventListeners();
        List<ServletRequestAttributeListener> listeners = eventListeners.get(ServletRequestAttributeListener.class);
        if (listeners.isEmpty()) {
            return;
        }
        ServletRequestAttributeEvent servletRequestAttributeEvent = new ServletRequestAttributeEvent(this.servletRegistration.getServletContext(), (ServletRequest)this.requestProxy, name, null);
        for (ServletRequestAttributeListener servletRequestAttributeListener : listeners) {
            servletRequestAttributeListener.attributeRemoved(servletRequestAttributeEvent);
        }
    }

    public void setAttribute(String name, Object value) {
        boolean added = this.request.getAttribute(name) == null;
        this.request.setAttribute(name, value);
        EventListeners eventListeners = this.dispatchTargets.getContextController().getEventListeners();
        List<ServletRequestAttributeListener> listeners = eventListeners.get(ServletRequestAttributeListener.class);
        if (listeners.isEmpty()) {
            return;
        }
        ServletRequestAttributeEvent servletRequestAttributeEvent = new ServletRequestAttributeEvent(this.servletRegistration.getServletContext(), (ServletRequest)this.requestProxy, name, value);
        for (ServletRequestAttributeListener servletRequestAttributeListener : listeners) {
            if (added) {
                servletRequestAttributeListener.attributeAdded(servletRequestAttributeEvent);
                continue;
            }
            servletRequestAttributeListener.attributeReplaced(servletRequestAttributeEvent);
        }
    }

    HttpServletRequest getOriginalRequest() {
        return this.request;
    }

    static interface RequestGetter {
        public HttpServletRequest getOriginalRequest();
    }
}

