/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.image;

import com.sun.javafx.css.converters.InsetsConverter;
import com.sun.javafx.css.converters.PaintConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.FontCssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.Insets;
import javafx.scene.control.Control;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import org.eclipse.fx.ui.controls.image.FontIcon;
import org.eclipse.fx.ui.controls.image.FontIconStyleConverter;
import org.eclipse.jdt.annotation.NonNull;

public class FontIconView
extends Control {
    private ObjectProperty<FontIcon> icon;
    ObjectProperty<Font> font;
    ObjectProperty<Insets> iconPadding;
    ObjectProperty<Paint> iconFill;

    public FontIconView() {
        this.getStyleClass().setAll((Object[])new String[]{"fonticonview"});
        this.setMouseTransparent(true);
    }

    protected String getUserAgentStylesheet() {
        String uri = FontIconView.class.getResource("fonticonview.css").toExternalForm();
        return uri;
    }

    @Deprecated
    protected Boolean impl_cssGetFocusTraversableInitialValue() {
        return Boolean.FALSE;
    }

    public ObjectProperty<FontIcon> iconProperty() {
        if (this.icon == null) {
            this.icon = new SimpleStyleableObjectProperty(StyleableProperties.ICON, (Object)FontIcon.create('?'));
        }
        return this.icon;
    }

    public void setIcon(FontIcon icon) {
        this.iconProperty().set((Object)icon);
    }

    public FontIcon getIcon() {
        return this.icon == null ? null : (FontIcon)this.icon.get();
    }

    public final @NonNull ObjectProperty<Font> fontProperty() {
        Object font = this.font;
        if (font == null) {
            this.font = font = new StyleableObjectProperty<Font>(Font.getDefault()){
                private boolean cssFont;
                {
                    this.cssFont = false;
                }

                public void applyStyle(StyleOrigin newOrigin, Font value) {
                    try {
                        this.cssFont = true;
                        super.applyStyle(newOrigin, (Object)value);
                    }
                    finally {
                        this.cssFont = false;
                    }
                }

                public void set(Font value) {
                    Font oldValue = (Font)this.get();
                    if (value != null ? !value.equals((Object)oldValue) : oldValue != null) {
                        super.set((Object)value);
                    }
                }

                protected void invalidated() {
                    if (!this.cssFont) {
                        FontIconView.this.impl_reapplyCSS();
                    }
                }

                public CssMetaData<FontIconView, Font> getCssMetaData() {
                    return StyleableProperties.FONT;
                }

                public Object getBean() {
                    return FontIconView.this;
                }

                public String getName() {
                    return "font";
                }
            };
        }
        return font;
    }

    public final void setFont(Font font) {
        this.fontProperty().setValue((Object)font);
    }

    public final Font getFont() {
        return this.font == null ? Font.getDefault() : (Font)this.font.getValue();
    }

    public final ReadOnlyObjectProperty<Insets> iconPaddingProperty() {
        return this.iconPaddingPropertyImpl();
    }

    ObjectProperty<Insets> iconPaddingPropertyImpl() {
        if (this.iconPadding == null) {
            this.iconPadding = new StyleableObjectProperty<Insets>(Insets.EMPTY){
                private Insets lastValidValue;
                {
                    this.lastValidValue = Insets.EMPTY;
                }

                public void invalidated() {
                    Insets newValue = (Insets)this.get();
                    if (newValue == null) {
                        this.set(this.lastValidValue);
                        throw new NullPointerException("Null not allowed");
                    }
                    this.lastValidValue = newValue;
                    FontIconView.this.requestLayout();
                }

                public CssMetaData<FontIconView, Insets> getCssMetaData() {
                    return StyleableProperties.ICON_PADDING;
                }

                public Object getBean() {
                    return FontIconView.this;
                }

                public String getName() {
                    return "iconPadding";
                }
            };
        }
        return this.iconPadding;
    }

    public final Insets getIconPadding() {
        return this.iconPadding == null ? Insets.EMPTY : (Insets)this.iconPadding.get();
    }

    public final void setIconFill(Paint value) {
        this.iconFillProperty().set((Object)value);
    }

    public final Paint getIconFill() {
        return this.iconFill == null ? Color.BLACK : (Paint)this.iconFill.get();
    }

    public final ObjectProperty<Paint> iconFillProperty() {
        if (this.iconFill == null) {
            this.iconFill = new StyleableObjectProperty<Paint>((Paint)Color.BLACK){

                public CssMetaData<FontIconView, Paint> getCssMetaData() {
                    return StyleableProperties.ICON_FILL;
                }

                public Object getBean() {
                    return FontIconView.this;
                }

                public String getName() {
                    return "iconFill";
                }
            };
        }
        return this.iconFill;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return FontIconView.getClassCssMetaData();
    }

    private static class StyleableProperties {
        static final FontCssMetaData<FontIconView> FONT = new FontCssMetaData<FontIconView>("-fx-font", Font.getDefault()){

            public boolean isSettable(FontIconView n) {
                return n.font == null || !n.font.isBound();
            }

            public StyleableProperty<Font> getStyleableProperty(FontIconView n) {
                return (StyleableProperty)n.fontProperty();
            }
        };
        static final CssMetaData<FontIconView, FontIcon> ICON = new CssMetaData<FontIconView, FontIcon>("-fx-icon", (StyleConverter)new FontIconStyleConverter()){

            public boolean isSettable(FontIconView styleable) {
                return true;
            }

            public StyleableProperty<FontIcon> getStyleableProperty(FontIconView styleable) {
                return (StyleableProperty)styleable.iconProperty();
            }
        };
        static final CssMetaData<FontIconView, Insets> ICON_PADDING = new CssMetaData<FontIconView, Insets>("-fx-icon-padding", InsetsConverter.getInstance(), Insets.EMPTY){

            public boolean isSettable(FontIconView n) {
                return n.iconPadding == null || !n.iconPadding.isBound();
            }

            public StyleableProperty<Insets> getStyleableProperty(FontIconView n) {
                return (StyleableProperty)n.iconPaddingPropertyImpl();
            }
        };
        static final CssMetaData<FontIconView, Paint> ICON_FILL = new CssMetaData<FontIconView, Paint>("-fx-icon-fill", PaintConverter.getInstance(), (Paint)Color.BLACK){

            public boolean isSettable(FontIconView n) {
                return n.iconFill == null || !n.iconFill.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(FontIconView n) {
                return (StyleableProperty)n.iconFillProperty();
            }
        };
        static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, FONT, ICON, ICON_FILL, ICON_PADDING);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }

        private StyleableProperties() {
        }
    }
}

