/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.Collection;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.Util;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class EventProcessor {
    public static <C extends MUIElement, M extends MElementContainer<C>, R extends BaseRenderer<M, ?>> void attachChildProcessor(IEventBroker eventBroker, final R renderer) {
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", new EventHandler(){

            public void handleEvent(Event event) {
                Object changedObj = event.getProperty("ChangedElement");
                MUIElement parent = (MUIElement)changedObj;
                if (parent.getRenderer() == renderer) {
                    if (UIEvents.isADD((Event)event)) {
                        ((ChildrenHandler)((Object)renderer)).handleChildrenAddition((MElementContainer)parent, Util.asCollection(event, "NewValue"));
                    } else if (UIEvents.isREMOVE((Event)event)) {
                        ((ChildrenHandler)((Object)renderer)).handleChildrenRemove((MElementContainer)parent, Util.asCollection(event, "OldValue"));
                    }
                }
            }
        });
    }

    public static <M extends MUIElement, R extends BaseRenderer<M, ?>> void attachVisibleProcessor(IEventBroker eventBroker, final R renderer) {
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/visible/*", new EventHandler(){

            public void handleEvent(Event event) {
                String eventType;
                EObject parent;
                MUIElement changedObj = (MUIElement)event.getProperty("ChangedElement");
                if (changedObj.isToBeRendered() && (parent = ((EObject)changedObj).eContainer()) instanceof MUIElement && ((MUIElement)parent).getRenderer() == renderer && "SET".equals(eventType = (String)event.getProperty("EventType"))) {
                    Boolean newValue = (Boolean)event.getProperty("NewValue");
                    if (newValue.booleanValue()) {
                        renderer.childRendered((MUIElement)parent, changedObj);
                    } else {
                        renderer.hideChild((MUIElement)parent, changedObj);
                    }
                }
            }
        });
    }

    public static interface ChildrenHandler<M extends MUIElement, C extends MUIElement> {
        public void handleChildrenAddition(M var1, Collection<C> var2);

        public void handleChildrenRemove(M var1, Collection<C> var2);
    }
}

