/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.tasks;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.tasks.TaskTag;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
public class TaskTags
implements Iterable<TaskTag> {
    private boolean caseSensitive;
    private final List<TaskTag> taskTags = CollectionLiterals.newArrayList();
    @Accessors(value={AccessorType.NONE})
    private Pattern pattern;
    @Accessors(value={AccessorType.NONE})
    private Map<String, TaskTag> taskTagsByName;

    @Override
    public Iterator<TaskTag> iterator() {
        return this.taskTags.iterator();
    }

    public Pattern toPattern() {
        if (this.pattern == null) {
            int flags = 8;
            if (!this.caseSensitive) {
                flags = flags | 2 | 0x40;
            }
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("^.*((");
            Functions.Function1 _function = it -> Pattern.quote(it.getName());
            String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.taskTags, (Functions.Function1)_function), (CharSequence)"|");
            _builder.append(_join);
            _builder.append(")(.*)?)$");
            this.pattern = Pattern.compile(_builder.toString(), flags);
        }
        return this.pattern;
    }

    public Map<String, TaskTag> getTaskTagsByName() {
        if (this.taskTagsByName == null) {
            HashMap<String, TaskTag> _hashMap = new HashMap<String, TaskTag>();
            this.taskTagsByName = _hashMap;
            for (TaskTag tag : this.taskTags) {
                String _xifexpression = null;
                _xifexpression = this.caseSensitive ? tag.getName() : tag.getName().toLowerCase();
                String name = _xifexpression;
                TaskTag oldTag = this.taskTagsByName.get(name);
                if (oldTag != null) {
                    int _ordinal_1;
                    int _ordinal = tag.getPriority().ordinal();
                    boolean _lessThan = _ordinal < (_ordinal_1 = oldTag.getPriority().ordinal());
                    if (!_lessThan) continue;
                    this.taskTagsByName.put(name, tag);
                    continue;
                }
                this.taskTagsByName.put(name, tag);
            }
        }
        return this.taskTagsByName;
    }

    @Pure
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Pure
    public List<TaskTag> getTaskTags() {
        return this.taskTags;
    }
}

