/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.text.DateFormat;
import java.util.Calendar;
import org.eclipse.core.runtime.Assert;

public class DateRange
implements Comparable<DateRange> {
    protected static final long DAY = 86400000L;
    private final Calendar startDate;
    private final Calendar endDate;

    public DateRange(Calendar time) {
        this.startDate = time;
        this.endDate = time;
    }

    public DateRange(Calendar startDate, Calendar endDate) {
        Assert.isNotNull((Object)startDate);
        Assert.isNotNull((Object)endDate);
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public boolean includes(DateRange range) {
        return this.startDate.getTimeInMillis() <= range.getStartDate().getTimeInMillis() && this.endDate.getTimeInMillis() >= range.getEndDate().getTimeInMillis();
    }

    public boolean includes(Calendar cal) {
        return this.startDate.getTimeInMillis() <= cal.getTimeInMillis() && this.endDate.getTimeInMillis() >= cal.getTimeInMillis();
    }

    public Calendar getStartDate() {
        return this.startDate;
    }

    public Calendar getEndDate() {
        return this.endDate;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean useDayOfWeekForNextWeek) {
        return DateFormat.getDateInstance(2).format(this.startDate.getTime());
    }

    public boolean isPresent() {
        return this.getStartDate().before(Calendar.getInstance()) && this.getEndDate().after(Calendar.getInstance());
    }

    public boolean isPast() {
        return this.getEndDate().compareTo(Calendar.getInstance()) < 0;
    }

    public boolean isFuture() {
        return !this.isPresent() && this.getStartDate().after(Calendar.getInstance());
    }

    public boolean isBefore(DateRange scheduledDate) {
        return this.getEndDate().compareTo(scheduledDate.getStartDate()) < 0;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = 31 * result + (this.startDate == null ? 0 : this.startDate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DateRange)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        DateRange other = (DateRange)obj;
        if (this.endDate == null ? other.endDate != null : !this.endDate.equals(other.endDate)) {
            return false;
        }
        return !(this.startDate == null ? other.startDate != null : !this.startDate.equals(other.startDate));
    }

    public boolean before(Calendar cal) {
        return this.getEndDate().before(cal);
    }

    public boolean after(Calendar cal) {
        return cal.before(this.getEndDate());
    }

    @Override
    public int compareTo(DateRange range) {
        if (range.getStartDate().equals(this.startDate) && range.getEndDate().equals(this.endDate)) {
            return 0;
        }
        if (this.includes(range)) {
            return 1;
        }
        if (this.before(range.getStartDate())) {
            return -1;
        }
        if (this.after(range.getEndDate())) {
            return 1;
        }
        return -1;
    }
}

