/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.product;

import org.eclipse.titan.common.utils.ObjectUtils;

public final class ProductIdentity
implements Comparable<ProductIdentity> {
    public static final String TITAN_PRODUCT_NUMBER = "CRL 113 200";
    private String productNumber = null;
    private int productNumberSuffix = 1;
    private int revisionDigit;
    private int revisionLetter;
    private int verificationStep;
    private boolean magicString;

    private ProductIdentity(String productNumber, int productNumberSuffix, int revisionDigit, int revisionLetter, int verificationStep) {
        this.productNumber = productNumber;
        this.productNumberSuffix = productNumberSuffix;
        this.revisionDigit = revisionDigit;
        this.revisionLetter = revisionLetter;
        this.verificationStep = verificationStep;
        this.magicString = false;
    }

    public ProductIdentity() {
        this.magicString = true;
    }

    private boolean isMagicString() {
        return this.magicString;
    }

    public static ProductIdentity getMagicVersionNumber() {
        return new ProductIdentity();
    }

    public static ProductIdentity getProductIdentity(String productNumber, long versionNumber) {
        int version = (int)versionNumber;
        if (version > 1000000) {
            int productNumberSuffix = version / 1000000;
            int revisionDigit = (version -= productNumberSuffix * 1000000) / 10000;
            int revisionLetter = (version -= revisionDigit * 10000) / 100;
            int verificationStep = version -= revisionLetter * 100;
            return new ProductIdentity(productNumber, productNumberSuffix, revisionDigit, revisionLetter, verificationStep);
        }
        int productNumberSuffix = version / 10000;
        int revisionDigit = (version -= productNumberSuffix * 10000) / 100;
        int revisionLetter = version -= revisionDigit * 100;
        return new ProductIdentity(productNumber, productNumberSuffix, revisionDigit, revisionLetter, 0);
    }

    public static ProductIdentity getProductIdentity(String productNumber, int productNumberSuffix, int revisionDigit, int revisionLetter, int verificationStep) {
        return new ProductIdentity(productNumber, productNumberSuffix, revisionDigit, revisionLetter, verificationStep);
    }

    @Override
    public int compareTo(ProductIdentity other) {
        if (this.magicString || other == null || other.isMagicString()) {
            return 0;
        }
        if (this.productNumberSuffix != other.productNumberSuffix) {
            return this.productNumberSuffix - other.productNumberSuffix;
        }
        if (this.revisionDigit != other.revisionDigit) {
            return this.revisionDigit - other.revisionDigit;
        }
        if (this.revisionLetter != other.revisionLetter) {
            return this.revisionLetter - other.revisionLetter;
        }
        if (this.verificationStep == 0) {
            if (other.verificationStep == 0) {
                return 0;
            }
            return 1;
        }
        if (other.verificationStep == 0) {
            return -1;
        }
        return this.verificationStep - other.verificationStep;
    }

    public String toString() {
        if (this.magicString) {
            return "RnXnn";
        }
        StringBuilder builder = new StringBuilder(17);
        if (this.productNumber != null) {
            builder.append(this.productNumber);
            if (this.productNumberSuffix == 0 || this.productNumberSuffix == 1 && this.revisionDigit < 9) {
                builder.append(' ');
            } else {
                builder.append('/').append(this.productNumberSuffix);
            }
            builder.append(' ');
        }
        builder.append('R').append(this.revisionDigit).append((char)(this.revisionLetter + 65));
        if (this.verificationStep != 0) {
            if (this.verificationStep < 10) {
                builder.append('0');
            }
            builder.append(this.verificationStep);
        }
        return builder.toString();
    }

    public int hashCode() {
        return ObjectUtils.hash(this.magicString, this.productNumber, this.productNumberSuffix, this.revisionDigit, this.revisionLetter, this.verificationStep);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ProductIdentity other = (ProductIdentity)obj;
        return ObjectUtils.equals(this.magicString, other.magicString) && ObjectUtils.equals(this.productNumber, other.productNumber) && ObjectUtils.equals(this.productNumberSuffix, other.productNumberSuffix) && ObjectUtils.equals(this.revisionDigit, other.revisionDigit) && ObjectUtils.equals(this.revisionLetter, other.revisionLetter) && ObjectUtils.equals(this.verificationStep, other.verificationStep);
    }
}

