/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.core.ProjectBasedBuilder;
import org.eclipse.titan.designer.properties.data.ProjectRemoteBuildPropertyData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProjectConfigurationsPropertyData {
    public static final String QUALIFIER = "org.eclipse.titan.designer.Properties.Project";
    public static final String REFERENCED_CONFIGURATION_INFO = "org.eclipse.titan.designer.referecedConfigurationInfo";
    public static final String CONFIGURATION_REQUIREMENTS_NODE = "ConfigurationRequirements";

    private ProjectConfigurationsPropertyData() {
    }

    public static List<ConfigurationRequirement> getConfigurationRequirements(IProject project) {
        IProject[] referencedProjects;
        String temp = null;
        try {
            temp = project.getPersistentProperty(new QualifiedName(QUALIFIER, REFERENCED_CONFIGURATION_INFO));
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While loading requirements of `" + project.getName() + "'"), (Throwable)e);
        }
        List<String> splittedList = ProjectRemoteBuildPropertyData.intelligentSplit(temp, '#', '\\');
        ArrayList<ConfigurationRequirement> result = new ArrayList<ConfigurationRequirement>(splittedList.size());
        for (String split : splittedList) {
            List<String> requirement = ProjectRemoteBuildPropertyData.intelligentSplit(split, ':', '\\');
            if (requirement == null || requirement.size() != 2) continue;
            result.add(new ConfigurationRequirement(requirement.get(0), requirement.get(1)));
        }
        for (IProject referencedProject : referencedProjects = ProjectBasedBuilder.getProjectBasedBuilder(project).getReferencedProjects()) {
            boolean found = false;
            String projectName = referencedProject.getName();
            int size = result.size();
            for (int i = 0; i < size && !found; ++i) {
                if (!projectName.equals(((ConfigurationRequirement)result.get(i)).projectName)) continue;
                found = true;
            }
            if (found) continue;
            ConfigurationRequirement requirement = new ConfigurationRequirement(projectName, "");
            result.add(requirement);
        }
        return result;
    }

    public static void setConfigurationRequirements(IProject project, List<ConfigurationRequirement> requirements) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (ConfigurationRequirement requirement : requirements) {
            if (i != 0) {
                builder.append('#');
            }
            String tempString1 = requirement.getProjectName().replace("\\", "\\\\").replace(":", "\\:");
            String tempString2 = requirement.getConfiguration().replace("\\", "\\\\").replace(":", "\\:");
            String tempString = tempString1 + ":" + tempString2;
            builder.append(tempString.replace("#", "\\#"));
            ++i;
        }
        QualifiedName qualifiedName = new QualifiedName(QUALIFIER, REFERENCED_CONFIGURATION_INFO);
        String newValue = builder.toString();
        try {
            String oldValue = project.getPersistentProperty(qualifiedName);
            if (newValue != null && !newValue.equals(oldValue)) {
                project.setPersistentProperty(qualifiedName, newValue);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While setting requirements of `" + project.getName() + "'"), (Throwable)e);
        }
    }

    public static Element saveProperties(Document document, IProject project) {
        Node root = null;
        List<ConfigurationRequirement> requirements = ProjectConfigurationsPropertyData.getConfigurationRequirements(project);
        if (requirements.isEmpty()) {
            return root;
        }
        for (ConfigurationRequirement requirement : requirements) {
            if (requirement.configuration == null || requirement.configuration.isEmpty()) continue;
            Element configurationRequirement = document.createElement("configurationRequirement");
            Element projectName = document.createElement("projectName");
            projectName.appendChild(document.createTextNode(requirement.getProjectName()));
            configurationRequirement.appendChild(projectName);
            Element configuration = document.createElement("rerquiredConfiguration");
            configuration.appendChild(document.createTextNode(requirement.configuration));
            configurationRequirement.appendChild(configuration);
            if (root == null) {
                root = document.createElement(CONFIGURATION_REQUIREMENTS_NODE);
            }
            root.appendChild(configurationRequirement);
        }
        return root;
    }

    public static void loadProperties(Node node, IProject project, Set<IResource> changedResources) {
        NodeList configurationRequirementList = node.getChildNodes();
        ArrayList<ConfigurationRequirement> requirements = new ArrayList<ConfigurationRequirement>();
        changedResources.add((IResource)project);
        for (int i = 0; i < configurationRequirementList.getLength(); ++i) {
            Node temp = configurationRequirementList.item(i);
            if (!"configurationRequirement".equals(temp.getNodeName())) continue;
            NodeList requirementInternalsList = temp.getChildNodes();
            String projectName = null;
            String configuration = null;
            for (int j = 0; j < requirementInternalsList.getLength(); ++j) {
                if ("projectName".equals(requirementInternalsList.item(j).getNodeName())) {
                    projectName = requirementInternalsList.item(j).getTextContent();
                    continue;
                }
                if (!"rerquiredConfiguration".equals(requirementInternalsList.item(j).getNodeName())) continue;
                configuration = requirementInternalsList.item(j).getTextContent();
            }
            if (projectName == null || configuration == null) continue;
            requirements.add(new ConfigurationRequirement(projectName, configuration));
        }
        ProjectConfigurationsPropertyData.setConfigurationRequirements(project, requirements);
    }

    public static Element copyProperties(Node source, Document document) {
        if (source == null) {
            return null;
        }
        NodeList configurationRequirementList = source.getChildNodes();
        ArrayList<ConfigurationRequirement> requirements = new ArrayList<ConfigurationRequirement>();
        for (int i = 0; i < configurationRequirementList.getLength(); ++i) {
            Node temp = configurationRequirementList.item(i);
            if (!"configurationRequirement".equals(temp.getNodeName())) continue;
            NodeList requirementInternalsList = temp.getChildNodes();
            String projectName = null;
            String configuration = null;
            for (int j = 0; j < requirementInternalsList.getLength(); ++j) {
                if ("projectName".equals(requirementInternalsList.item(j).getNodeName())) {
                    projectName = requirementInternalsList.item(j).getTextContent();
                    continue;
                }
                if (!"rerquiredConfiguration".equals(requirementInternalsList.item(j).getNodeName())) continue;
                configuration = requirementInternalsList.item(j).getTextContent();
            }
            if (projectName == null || configuration == null) continue;
            requirements.add(new ConfigurationRequirement(projectName, configuration));
        }
        Node root = null;
        if (requirements.isEmpty()) {
            return root;
        }
        for (ConfigurationRequirement requirement : requirements) {
            if (requirement.configuration == null || requirement.configuration.isEmpty()) continue;
            Element configurationRequirement = document.createElement("configurationRequirement");
            Element projectName = document.createElement("projectName");
            projectName.appendChild(document.createTextNode(requirement.getProjectName()));
            configurationRequirement.appendChild(projectName);
            Element configuration = document.createElement("rerquiredConfiguration");
            configuration.appendChild(document.createTextNode(requirement.configuration));
            configurationRequirement.appendChild(configuration);
            if (root == null) {
                root = document.createElement(CONFIGURATION_REQUIREMENTS_NODE);
            }
            root.appendChild(configurationRequirement);
        }
        return root;
    }

    public static void removeTITANAttributes(IProject project) {
        try {
            project.setPersistentProperty(new QualifiedName(QUALIFIER, REFERENCED_CONFIGURATION_INFO), null);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While removing attributes of `" + project.getName() + "'"), (Throwable)e);
        }
    }

    public static class ConfigurationRequirement {
        private String projectName;
        private String configuration;

        public ConfigurationRequirement(String projectName, String configuration) {
            this.projectName = projectName;
            this.configuration = configuration;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getConfiguration() {
            return this.configuration;
        }

        public void setConfiguration(String configuration) {
            this.configuration = configuration;
        }
    }
}

