/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.graphics;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class ImageCache {
    private static final String ICONS_SUBDIR = "icons/";
    private static Map<ImageDescriptor, Image> imageCache = new ConcurrentHashMap<ImageDescriptor, Image>();

    private ImageCache() {
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.titan.designer", (String)(ICONS_SUBDIR + name));
    }

    public static Image getImage(String name) {
        ImageDescriptor descriptor = ImageCache.getImageDescriptor(name);
        if (descriptor == null) {
            return null;
        }
        if (imageCache.containsKey(descriptor)) {
            return imageCache.get(descriptor);
        }
        Image image = descriptor.createImage();
        imageCache.put(descriptor, image);
        return image;
    }
}

