/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Def_ExternalConst
extends Definition {
    private static final String FULLNAMEPART = ".<type>";
    public static final String PORTNOTALLOWED = "External constant can not be defined for port type `{0}''";
    public static final String SIGNATURENOTALLOWED = "External constant can not be defined for signature type `{0}''";
    private static final String KIND = "external constant";
    private final Type type;

    public Def_ExternalConst(Identifier identifier, Type type) {
        super(identifier);
        this.type = type;
        if (type != null) {
            type.setFullNameParent(this);
        }
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return Assignment.Assignment_type.A_EXT_CONST;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.type == child) {
            return builder.append(FULLNAMEPART);
        }
        return builder;
    }

    @Override
    public String getAssignmentName() {
        return KIND;
    }

    @Override
    public String getOutlineIcon() {
        return "constant_external.gif";
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.type != null) {
            this.type.setMyScope(scope);
        }
    }

    @Override
    public Type getType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.type;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.isUsed = false;
        NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionExternalConstant", this.identifier, this);
        NamingConventionHelper.checkNameContents(this.identifier, this.getMyScope().getModuleScope().getIdentifier(), this.getDescription());
        if (this.type == null) {
            return;
        }
        this.type.check(timestamp);
        IType astType = this.type.getTypeRefdLast(timestamp);
        switch (astType.getTypetype()) {
            case TYPE_PORT: {
                this.location.reportSemanticError(MessageFormat.format(PORTNOTALLOWED, astType.getFullName()));
                break;
            }
            case TYPE_SIGNATURE: {
                this.location.reportSemanticError(MessageFormat.format(SIGNATURENOTALLOWED, astType.getFullName()));
                break;
            }
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.checkGlobalAttributes(timestamp, false);
            this.withAttributesPath.checkAttributes(timestamp);
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void postCheck() {
        super.postCheck();
        this.postCheckPrivateness();
    }

    @Override
    public String getProposalKind() {
        return KIND;
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= i) {
            return;
        }
        if (subrefs.size() == i + 1 && this.identifier.getName().toLowerCase().startsWith(subrefs.get(i).getId().getName().toLowerCase())) {
            super.addProposal(propCollector, i);
        } else if (subrefs.size() > i + 1 && this.type != null && this.identifier.getName().equals(subrefs.get(i).getId().getName())) {
            this.type.addProposal(propCollector, i + 1);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() >= i + 1 && this.identifier.getName().equals(subrefs.get(i).getId().getName())) {
            if (subrefs.size() > i + 1 && this.type != null) {
                this.type.addDeclaration(declarationCollector, i + 1);
            } else if (subrefs.size() == i + 1 && ISubReference.Subreference_type.fieldSubReference.equals((Object)subrefs.get(i).getReferenceType())) {
                declarationCollector.addDeclaration(this);
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean enveloped = false;
            Location temporalIdentifier = this.identifier.getLocation();
            if (reparser.envelopsDamage(temporalIdentifier) || reparser.isExtending(temporalIdentifier)) {
                reparser.extendDamagedRegion(temporalIdentifier);
                IdentifierReparser r = new IdentifierReparser(reparser);
                int result = r.parseAndSetNameChanged();
                this.identifier = r.getIdentifier();
                if (result == 0) {
                    enveloped = true;
                } else {
                    throw new ReParseException(result);
                }
            }
            if (this.type != null) {
                if (enveloped) {
                    this.type.updateSyntax(reparser, false);
                    reparser.updateLocation(this.type.getLocation());
                } else if (reparser.envelopsDamage(this.type.getLocation())) {
                    this.type.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.type.getLocation());
                }
            }
            if (this.withAttributesPath != null) {
                if (enveloped) {
                    this.withAttributesPath.updateSyntax(reparser, false);
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                } else if (reparser.envelopsDamage(this.withAttributesPath.getLocation())) {
                    this.withAttributesPath.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                }
            }
            if (!enveloped) {
                throw new ReParseException();
            }
            return;
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.type != null) {
            this.type.updateSyntax(reparser, false);
            reparser.updateLocation(this.type.getLocation());
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.type != null) {
            this.type.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.type == null || this.type.accept(v);
    }
}

