/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.refactoring;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.pde.internal.core.project.PDEProject;

public abstract class PDEMoveParticipant
extends MoveParticipant
implements ISharableParticipant {
    protected IProject fProject;
    protected HashMap<Object, String> fElements;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public void addElement(Object element, RefactoringArguments arguments) {
        Object destination = ((MoveArguments)arguments).getDestination();
        this.fElements.put(element, this.getNewName(destination, element));
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange result = new CompositeChange(this.getName());
        this.addChange(result, pm);
        if (this.isInterestingForExtensions()) {
            this.addChange(result, PDEProject.getPluginXml((IProject)this.fProject), pm);
            this.addChange(result, PDEProject.getFragmentXml((IProject)this.fProject), pm);
        }
        return result.getChildren().length == 0 ? null : result;
    }

    protected abstract boolean isInterestingForExtensions();

    protected void addChange(CompositeChange result, IFile file, IProgressMonitor pm) throws CoreException {
    }

    protected void addChange(CompositeChange result, IProgressMonitor pm) throws CoreException {
    }

    protected String getNewName(Object destination, Object element) {
        return element.toString();
    }

    protected String[] getNewNames() {
        String[] result = new String[this.fElements.size()];
        Iterator<String> iter = this.fElements.values().iterator();
        int i = 0;
        while (i < this.fElements.size()) {
            result[i] = iter.next().toString();
            ++i;
        }
        return result;
    }
}

