/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.sew.launcher.workflow;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.efm.sew.launcher.workflow.IWorkflowConfigurationConstants;
import org.eclipse.efm.sew.launcher.workflow.common.CommonFactory;
import org.eclipse.efm.sew.launcher.workflow.common.Location;
import org.eclipse.efm.sew.launcher.workflow.common.impl.WorkspaceImpl;
import org.eclipse.efm.sew.launcher.workflow.util.PrettyPrintWriter;

public class WorkspaceCustomImpl
extends WorkspaceImpl
implements IWorkflowConfigurationConstants {
    public static WorkspaceCustomImpl create(ILaunchConfiguration configuration, IPath rootPath) {
        String str;
        WorkspaceCustomImpl workspace = new WorkspaceCustomImpl();
        Location location = CommonFactory.eINSTANCE.createLocation();
        location.setRoot(rootPath.toString());
        try {
            str = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_WORKSPACE_OUTPUT_FOLDER_NAME", "output");
        }
        catch (CoreException e) {
            e.printStackTrace();
            str = "output";
        }
        if (str == null || str.isEmpty()) {
            str = "output";
        }
        location.setOutput(str);
        try {
            str = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_WORKSPACE_LOG_FOLDER_NAME", "log");
        }
        catch (CoreException e) {
            e.printStackTrace();
            str = "log";
        }
        if (str == null || str.isEmpty()) {
            str = "log";
        }
        location.setLog(str);
        try {
            str = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_WORKSPACE_DEBUG_FOLDER_NAME", "debug");
        }
        catch (CoreException e) {
            e.printStackTrace();
            str = "debug";
        }
        if (str == null || str.isEmpty()) {
            str = "debug";
        }
        location.setDebug(str);
        workspace.setLocation(location);
        return workspace;
    }

    public void toWriter(PrettyPrintWriter writer) {
        writer.appendTabEol("workspace [");
        Location location = this.getLocation();
        writer.appendTab2("root   = \"").append(location.getRoot()).appendEol("\"");
        writer.appendTab2("output = \"").append(location.getOutput()).appendEol("\"");
        writer.appendTab2("log    = \"").append(location.getLog()).appendEol("\"");
        writer.appendTab2("debug  = \"").append(location.getDebug()).appendEol("\"");
        writer.appendTabEol("] // end workspace");
    }
}

