/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Const;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ExternalConst;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Extfunction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ModulePar;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.types.Referenced_Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class TypenameInDef
extends BaseModuleCodeSmellSpotter {
    private static final String REPORT = "The name `{1}'' of the {0} contains it''s type''s name `{2}''";
    protected final CompilationTimeStamp timestamp = CompilationTimeStamp.getBaseTimestamp();

    public TypenameInDef() {
        super(CodeSmellType.TYPENAME_IN_DEFINITION);
    }

    @Override
    protected void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        if (!(node instanceof Def_Const || node instanceof Def_ExternalConst || node instanceof Def_Extfunction || node instanceof Def_Function || node instanceof Def_ModulePar || node instanceof Def_Template || node instanceof Def_Var_Template || node instanceof Def_Var)) {
            return;
        }
        Definition s = (Definition)node;
        this.check(s.getIdentifier(), s.getType(this.timestamp), s.getDescription(), problems);
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(8);
        ret.add(Def_Const.class);
        ret.add(Def_ExternalConst.class);
        ret.add(Def_Extfunction.class);
        ret.add(Def_Function.class);
        ret.add(Def_ModulePar.class);
        ret.add(Def_Template.class);
        ret.add(Def_Var_Template.class);
        ret.add(Def_Var.class);
        return ret;
    }

    private void check(Identifier identifier, IType type, String description, BaseCodeSmellSpotter.Problems problems) {
        String typeName;
        if (type == null) {
            return;
        }
        String displayName = identifier.getDisplayName();
        Identifier typeId = null;
        if (type instanceof Referenced_Type) {
            Referenced_Type referencedType = (Referenced_Type)type;
            typeId = referencedType.getReference().getId();
        }
        if (displayName.contains(typeName = typeId == null ? type.getTypename() : typeId.getDisplayName())) {
            String msg = MessageFormat.format(REPORT, description, displayName, typeName);
            problems.report(identifier.getLocation(), msg);
        }
    }
}

