/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.models;

import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.StringUtils;

public class SourceInformation {
    private String sourceFileName;
    private int lineNumber;

    private SourceInformation(String sourceFileName, int lineNumber) {
        this.sourceFileName = sourceFileName;
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public static SourceInformation createInstance(String sourceInformationString) throws InvalidSourceInformationException {
        if (StringUtils.isNullOrEmpty((String)sourceInformationString)) {
            throw new InvalidSourceInformationException();
        }
        String lastStackElem = SourceInformation.getLastElementOfCallStack(sourceInformationString);
        String pathAndLineNumber = SourceInformation.getPathAndLineNumber(lastStackElem);
        int indexOfColon = pathAndLineNumber.indexOf(58);
        if (indexOfColon == -1) {
            throw new InvalidSourceInformationException();
        }
        String newPath = pathAndLineNumber.substring(0, indexOfColon);
        String lineInfo = pathAndLineNumber.substring(indexOfColon + 1);
        lineInfo = lineInfo.replace(":", "");
        try {
            int newLineNumber = Integer.parseInt(lineInfo);
            String fileName = newPath;
            int lastSeparator = newPath.lastIndexOf(92);
            if (lastSeparator == -1) {
                lastSeparator = newPath.lastIndexOf(47);
            }
            if (lastSeparator != -1) {
                fileName = newPath.substring(lastSeparator + 1);
            }
            return new SourceInformation(fileName, newLineNumber);
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            throw new InvalidSourceInformationException();
        }
    }

    private static String getPathAndLineNumber(String lastStackElem) {
        int indexOfPar = lastStackElem.indexOf("(");
        if (indexOfPar != -1) {
            return lastStackElem.substring(0, indexOfPar);
        }
        return lastStackElem;
    }

    private static String getLastElementOfCallStack(String sourceInformationString) {
        int index = sourceInformationString.lastIndexOf("->");
        if (index != -1) {
            return sourceInformationString.substring(index + 2);
        }
        return sourceInformationString;
    }

    public static class InvalidSourceInformationException
    extends Exception {
    }
}

