/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.nls;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.PreDestroy;
import org.eclipse.e4.core.internal.services.ResourceBundleHelper;
import org.eclipse.e4.core.services.nls.MessageConsumer;
import org.eclipse.e4.core.services.nls.MessageFunction;
import org.eclipse.e4.core.services.nls.MessageSupplier;
import org.osgi.service.log.LogService;

public class BaseMessageRegistry<M> {
    private M messages;
    private final Map<MessageConsumer, MessageSupplier> bindings = new HashMap<MessageConsumer, MessageSupplier>();

    public void register(MessageConsumer consumer, final MessageFunction<M> function) {
        this.register(consumer, new MessageSupplier(){

            @Override
            public String get() {
                return function.apply(BaseMessageRegistry.this.messages);
            }
        });
    }

    public void register(MessageConsumer consumer, MessageSupplier supplier) {
        consumer.accept(supplier.get());
        this.bindings.put(consumer, supplier);
    }

    public void register(Object control, String method, String messageKey) {
        MessageConsumer consumer = this.createConsumer(control, method);
        MessageSupplier supplier = this.createSupplier(messageKey);
        if (consumer != null && supplier != null) {
            this.register(consumer, supplier);
        }
    }

    public void registerProperty(Object control, String property, String messageKey) {
        MessageConsumer consumer = this.createConsumer(control, "set" + Character.toUpperCase(property.charAt(0)) + property.substring(1));
        MessageSupplier supplier = this.createSupplier(messageKey);
        if (consumer != null && supplier != null) {
            this.register(consumer, supplier);
        }
    }

    public void updateMessages(M messages) {
        this.messages = messages;
        for (Map.Entry<MessageConsumer, MessageSupplier> entry : this.bindings.entrySet()) {
            entry.getKey().accept(entry.getValue().get());
        }
    }

    protected MessageConsumer createConsumer(Object control, String method) {
        block5: {
            LogService logService = ResourceBundleHelper.getLogService();
            try {
                Method m = control.getClass().getMethod(method, String.class);
                if (m != null) {
                    return new MessageConsumerImplementation(logService, m, control);
                }
            }
            catch (NoSuchMethodException e) {
                if (logService != null) {
                    logService.log(2, "The method '" + e.getMessage() + "' does not exist. Binding is not created!");
                }
            }
            catch (SecurityException e) {
                if (logService == null) break block5;
                logService.log(2, "Error on accessing method '" + method + "' on class '" + control.getClass() + "' with error message '" + e.getMessage() + "'. Binding is not created!");
            }
        }
        return null;
    }

    protected MessageSupplier createSupplier(String messageKey) {
        block5: {
            LogService logService = ResourceBundleHelper.getLogService();
            try {
                Field f = this.messages.getClass().getField(messageKey);
                if (f != null) {
                    return new MessageSupplierImplementation(logService, f);
                }
            }
            catch (NoSuchFieldException e) {
                if (logService != null) {
                    logService.log(2, "The class '" + this.messages.getClass().getName() + "' does not contain a field with name '" + e.getMessage() + "'. Binding is not created!");
                }
            }
            catch (SecurityException e) {
                if (logService == null) break block5;
                logService.log(2, "Error on accessing field '" + messageKey + "' on class '" + this.messages.getClass() + "' with error message '" + e.getMessage() + "'. Binding is not created!");
            }
        }
        return null;
    }

    @PreDestroy
    void unregister() {
        this.bindings.clear();
    }

    private final class MessageConsumerImplementation
    implements MessageConsumer {
        private final LogService logService;
        private final Method m;
        private final Object control;

        private MessageConsumerImplementation(LogService logService, Method m, Object control) {
            this.logService = logService;
            this.m = m;
            this.control = control;
        }

        @Override
        public void accept(final String value) {
            block4: {
                try {
                    if (System.getSecurityManager() == null) {
                        this.m.setAccessible(true);
                        this.m.invoke(this.control, value);
                    } else {
                        AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                block2: {
                                    MessageConsumerImplementation.this.m.setAccessible(true);
                                    try {
                                        MessageConsumerImplementation.this.m.invoke(MessageConsumerImplementation.this.control, value);
                                    }
                                    catch (Exception e) {
                                        BaseMessageRegistry.this.bindings.remove(MessageConsumerImplementation.this);
                                        if (MessageConsumerImplementation.this.logService == null) break block2;
                                        MessageConsumerImplementation.this.logService.log(3, "Error on invoke '" + MessageConsumerImplementation.this.m.getName() + "' on '" + MessageConsumerImplementation.this.control.getClass() + "' with error message '" + e.getMessage() + "'. Binding is removed.");
                                    }
                                }
                                return null;
                            }
                        });
                    }
                }
                catch (Exception e) {
                    BaseMessageRegistry.this.bindings.remove(this);
                    if (this.logService == null) break block4;
                    this.logService.log(3, "Error on invoke '" + this.m.getName() + "' on '" + this.control.getClass() + "' with error message '" + e.getMessage() + "'. Binding is removed.");
                }
            }
        }
    }

    private final class MessageSupplierImplementation
    implements MessageSupplier {
        private final LogService logService;
        private final Field f;

        private MessageSupplierImplementation(LogService logService, Field f) {
            this.logService = logService;
            this.f = f;
        }

        @Override
        public String get() {
            String message;
            block2: {
                message = null;
                try {
                    message = (String)this.f.get(BaseMessageRegistry.this.messages);
                }
                catch (Exception e) {
                    Iterator iterator = BaseMessageRegistry.this.bindings.entrySet().iterator();
                    iterator.forEachRemaining(entry -> {
                        if (entry.getValue() == this) {
                            iterator.remove();
                        }
                    });
                    if (this.logService == null) break block2;
                    this.logService.log(3, "Error on invoke '" + this.f.getName() + "' on '" + BaseMessageRegistry.this.messages.getClass() + "' with error message '" + e.getMessage() + "'. Binding is removed.");
                }
            }
            return message;
        }
    }
}

