/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurro;

import jakarta.enterprise.concurrent.ManagedTaskListener;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.glassfish.concurro.AbstractManagedExecutorService;
import org.glassfish.concurro.internal.ManagedFutureTask;
import org.glassfish.concurro.internal.TaskDoneCallback;

public class ManagedExecutorCompletionService<V>
implements TaskDoneCallback<V> {
    private final AbstractManagedExecutorService executor;
    private final BlockingQueue<Future<V>> completionQueue;

    public ManagedExecutorCompletionService(AbstractManagedExecutorService executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.completionQueue = new LinkedBlockingQueue<Future<V>>();
    }

    public ManagedExecutorCompletionService(AbstractManagedExecutorService executor, BlockingQueue<Future<V>> completionQueue) {
        if (executor == null || completionQueue == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.completionQueue = completionQueue;
    }

    public Future<V> submit(Callable<V> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        ManagedFutureTask<V> futureTask = this.executor.getNewTaskFor(task);
        futureTask.setTaskDoneCallback(this);
        this.executor.executeManagedFutureTask(futureTask);
        return futureTask;
    }

    public Future<V> submit(Runnable task, V result, ManagedTaskListener taskListener) {
        if (task == null) {
            throw new NullPointerException();
        }
        ManagedFutureTask<V> futureTask = this.executor.getNewTaskFor(task, result);
        futureTask.setTaskDoneCallback(this);
        this.executor.executeManagedFutureTask(futureTask);
        return futureTask;
    }

    public Future<V> take() throws InterruptedException {
        return this.completionQueue.take();
    }

    public Future<V> poll() {
        return (Future)this.completionQueue.poll();
    }

    public Future<V> poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.completionQueue.poll(timeout, unit);
    }

    @Override
    public void taskDone(ManagedFutureTask<V> future) {
        this.completionQueue.add(future);
    }
}

