/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.util.string;

public class CharBuffer {
    private char[] value;
    private int cnt;

    public CharBuffer() {
        this(16);
    }

    public CharBuffer(int len) {
        this.value = new char[len];
    }

    public int length() {
        return this.cnt;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.value.length) {
            this.expandCapacity(minCapacity);
        }
    }

    private void expandCapacity(int minCapacity) {
        int capacity = (this.value.length + 1) * 2;
        if (minCapacity > capacity) {
            capacity = minCapacity;
        }
        char[] newVal = new char[capacity];
        System.arraycopy(this.value, 0, newVal, 0, this.cnt);
        this.value = newVal;
    }

    public void setLength(int newLen) {
        if (newLen > this.value.length) {
            this.expandCapacity(newLen);
        }
        if (this.cnt < newLen) {
            while (this.cnt < newLen) {
                this.value[this.cnt] = '\u0000';
                ++this.cnt;
            }
        } else {
            this.cnt = newLen;
        }
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.cnt) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    public void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.cnt) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.value[index] = ch;
    }

    public void append(String str) {
        int len;
        int newcnt;
        if (str == null) {
            str = String.valueOf(str);
        }
        if ((newcnt = this.cnt + (len = str.length())) > this.value.length) {
            this.expandCapacity(newcnt);
        }
        str.getChars(0, len, this.value, this.cnt);
        this.cnt = newcnt;
    }

    public void append(char[] str, int offset, int len) {
        int newcnt = this.cnt + len;
        if (newcnt > this.value.length) {
            this.expandCapacity(newcnt);
        }
        System.arraycopy(str, offset, this.value, this.cnt, len);
        this.cnt = newcnt;
    }

    public void append(char[] str) {
        this.append(str, 0, str.length);
    }

    public void append(char c) {
        int newcount = this.cnt + 1;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        this.value[this.cnt++] = c;
    }

    public String substring(int start, int end) {
        return new String(this.value, start, end - start);
    }

    public String trim() {
        int len = this.cnt;
        int st = 0;
        int off = 0;
        char[] newVal = this.value;
        while (st < len && newVal[off + st] <= ' ') {
            ++st;
        }
        while (st < len && newVal[off + len - 1] <= ' ') {
            --len;
        }
        return st > 0 || len < this.cnt ? this.substring(st, len) : this.toString();
    }

    public boolean equals(int offset, String with) {
        int len = with.length();
        if (offset >= this.cnt || offset + len != this.cnt) {
            return false;
        }
        int i = offset;
        while (i < this.cnt) {
            if (this.value[i] != with.charAt(i - offset)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void getChars(int srcStart, int srcEnd, char[] dest, int destStart) {
        if (srcStart < 0 || srcStart >= this.cnt) {
            throw new StringIndexOutOfBoundsException(srcStart);
        }
        if (srcEnd < 0 || srcEnd > this.cnt) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcStart < srcEnd) {
            System.arraycopy(this.value, srcStart, dest, destStart, srcEnd - srcStart);
        } else if (srcStart > srcEnd) {
            throw new StringIndexOutOfBoundsException(srcEnd - srcStart);
        }
    }

    public String toString() {
        return new String(this.value, 0, this.cnt);
    }

    public char[] getValue() {
        char[] retVal = new char[this.cnt];
        System.arraycopy(this.value, 0, retVal, 0, this.cnt);
        return retVal;
    }
}

