/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.model.entities;

import java.io.Serializable;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;


/**
 * The persistent class for the sbi_threshold database table.
 * 
 */
@Entity
@Table(name="SBI_THRESHOLD")
public class SbiThreshold implements Serializable {
	private static final long serialVersionUID = 1L;

    @TableGenerator(name="trId", table="ID_GEN",
            pkColumnName="ID_NAME", valueColumnName="ID_VAL",
            pkColumnValue="THRESHOLD_ID", allocationSize=1)
	@Id
    @GeneratedValue(generator="trId", strategy=GenerationType.TABLE) 
	@Column(name="THRESHOLD_ID")
	private Integer thresholdId;

	@Column(name="CODE")
	private String code;

	@Column(name="DESCRIPTION")
	private String description;

	@Column(name="NAME")
	private String name;

	//bi-directional many-to-one association to SbiDomain
    @ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="THRESHOLD_TYPE_ID")
	private SbiDomain sbiDomain;

	//bi-directional many-to-one association to SbiThresholdValue
	@OneToMany(mappedBy="sbiThreshold",fetch=FetchType.LAZY)
	private Set<SbiThresholdValue> sbiThresholdValues;

    public SbiThreshold() {
    }

	public int getThresholdId() {
		return this.thresholdId;
	}

	public void setThresholdId(int thresholdId) {
		this.thresholdId = thresholdId;
	}

	public String getCode() {
		return this.code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public SbiDomain getSbiDomain() {
		return this.sbiDomain;
	}

	public void setSbiDomain(SbiDomain sbiDomain) {
		this.sbiDomain = sbiDomain;
	}
	
	public Set<SbiThresholdValue> getSbiThresholdValues() {
		return this.sbiThresholdValues;
	}

	public void setSbiThresholdValues(Set<SbiThresholdValue> sbiThresholdValues) {
		this.sbiThresholdValues = sbiThresholdValues;
	}
	
}