/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.ejb.CMRField;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.model.internal.validation.AComponentVRule;
import org.eclipse.jst.j2ee.model.internal.validation.IComponentType;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IMessagePrefixEjb20Constants;
import org.eclipse.jst.j2ee.model.internal.validation.IRemoteType;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRuleList;
import org.eclipse.jst.j2ee.model.internal.validation.InvalidInputException;
import org.eclipse.jst.j2ee.model.internal.validation.MessageUtility;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public final class CMPRemoteComponentVRule
extends AComponentVRule
implements IRemoteType,
IComponentType,
IMessagePrefixEjb20Constants {
    private static final Object ID = IValidationRuleList.EJB20_CMP_REMOTE;
    private static final Object[] DEPENDS_ON = new Object[]{IValidationRuleList.EJB20_CMP_BEANCLASS};
    private static final Map MESSAGE_IDS;
    private static final String MSSGID = ".crc";
    private static final String EXT = ".crc.ejb20";
    private static final String BEXT = ".crc.i.ejb20";
    private static final String MEXT = ".crc.m.ejb20";
    private final long[] SUPERTYPES = new long[]{JAVAX_EJB_EJBOBJECT};
    private final long[] SHOULD_NOT_BE_SUPERTYPES = null;
    private final long[] METHODS_WHICH_MUST_EXIST = null;
    private static final long[] METHODS_WHICH_MUST_NOT_EXIST;
    private final long[] KNOWN_METHOD_TYPES = new long[]{CLINIT, EJBSELECT};

    static {
        METHODS_WHICH_MUST_NOT_EXIST = new long[]{EJBSELECT};
        MESSAGE_IDS = new HashMap();
        MESSAGE_IDS.put("CHKJ2017", new String[]{"CHKJ2017.crc.ejb20"});
        MESSAGE_IDS.put("CHKJ2023", new String[]{"CHKJ2023.crc.i.ejb20", "CHKJ2023.crc.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2404", new String[]{"CHKJ2404.i.ejb20", "CHKJ2404.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2105", new String[]{"CHKJ2105.ejb20"});
        MESSAGE_IDS.put("CHKJ2416", new String[]{"CHKJ2416.i.ejb20", "CHKJ2416.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2433", new String[]{"CHKJ2433"});
        MESSAGE_IDS.put("CHKJ2468", new String[]{"CHKJ2468.crc.i.ejb20", "CHKJ2468.crc.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2469", new String[]{"CHKJ2469.crc.i.ejb20", "CHKJ2469.crc.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2470", new String[]{"CHKJ2470.crc.i.ejb20", "CHKJ2470.crc.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2471", new String[]{"CHKJ2471.crc.i.ejb20", "CHKJ2471.crc.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2472", new String[]{"CHKJ2472.crc.i.ejb20", "CHKJ2472.crc.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2473", new String[]{"CHKJ2473.crc.i.ejb20", "CHKJ2473.crc.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2474", new String[]{"CHKJ2474.crc.i.ejb20", "CHKJ2474.crc.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2500.bus", new String[]{"CHKJ2500.bus.crc.i.ejb20", "CHKJ2500.bus.crc.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2500.create", new String[]{"CHKJ2500.create.crc.i.ejb20", "CHKJ2500.create.crc.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2500.home", new String[]{"CHKJ2500.home.crc.i.ejb20", "CHKJ2500.home.crc.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2502.ejbSelect", new String[]{"CHKJ2502.ejbSelect.crc.i.ejb20", "CHKJ2502.ejbSelect.crc.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2503.bus", new String[]{"CHKJ2503.bus.crc.i.ejb20", "CHKJ2503.bus.crc.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2907", new String[]{"CHKJ2907"});
    }

    public final Map getMessageIds() {
        return MESSAGE_IDS;
    }

    public final int getMessageRemoteExceptionSeverity() {
        return 1;
    }

    public final Object[] getDependsOn() {
        return DEPENDS_ON;
    }

    public final Object getId() {
        return ID;
    }

    public final long[] getBaseTypes() {
        return this.getSupertypes();
    }

    public final long[] getSupertypes() {
        return this.SUPERTYPES;
    }

    public final long[] getShouldNotBeSupertypes() {
        return this.SHOULD_NOT_BE_SUPERTYPES;
    }

    public final int isRemote() {
        return 1;
    }

    public final long[] getMethodsWhichMustExist() {
        return this.METHODS_WHICH_MUST_EXIST;
    }

    public final long[] getMethodsWhichMustNotExist() {
        return METHODS_WHICH_MUST_NOT_EXIST;
    }

    public final long[] getKnownMethodTypes() {
        return this.KNOWN_METHOD_TYPES;
    }

    public void validate(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws ValidationCancelledException, InvalidInputException, ValidationException {
        super.validate(vc, bean, clazz);
        ContainerManagedEntity cmp = (ContainerManagedEntity)bean;
        List cmrFields = cmp.getCMRFields();
        for (CMRField cmrField : cmrFields) {
            JavaClass localType;
            if (cmrField == null || cmrField.isDerived() || (localType = ValidationRuleUtility.getCMRFieldType(vc, cmp, clazz, cmrField)) == null) continue;
            Method remoteGetMethod = ValidationRuleUtility.getMethodExtended(clazz, cmrField.getGetterName(), new JavaHelpers[0], (JavaHelpers)localType);
            if (remoteGetMethod != null) {
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2473", 2, (EnterpriseBean)cmp, clazz, remoteGetMethod, new String[]{cmrField.getGetterName()}, (IValidationRule)this);
                vc.addMessage(message);
            }
            JavaHelpers[] setMethodParms = new JavaHelpers[]{localType};
            Method remoteSetMethod = ValidationRuleUtility.getMethodExtended(clazz, cmrField.getSetterName(), setMethodParms);
            if (remoteSetMethod == null) continue;
            String setterName = String.valueOf(cmrField.getSetterName()) + "(" + ValidationRuleUtility.getParmsAsString(setMethodParms) + ")";
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2473", 2, (EnterpriseBean)cmp, clazz, remoteSetMethod, new String[]{setterName}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }
}

