/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.layout.ILayoutManager;
import org.eclipse.birt.report.engine.layout.html.HTMLAbstractLM;
import org.eclipse.birt.report.engine.layout.html.HTMLBlockStackingLM;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutManagerFactory;
import org.eclipse.birt.report.engine.layout.html.buffer.IPageBuffer;

public class HTMLGroupLM
extends HTMLBlockStackingLM {
    boolean isFirstLayout = true;
    boolean isHeaderRefined = false;

    public HTMLGroupLM(HTMLLayoutManagerFactory factory) {
        super(factory);
    }

    public int getType() {
        return 8;
    }

    public void initialize(HTMLAbstractLM parent, IContent content, IReportItemExecutor executor, IContentEmitter emitter) throws BirtException {
        super.initialize(parent, content, executor, emitter);
        this.isFirstLayout = true;
        this.isHeaderRefined = false;
    }

    protected boolean isHeaderBand() {
        IContent band;
        if (this.childLayout != null && (band = ((HTMLAbstractLM)this.childLayout).getContent()) instanceof IBandContent) {
            return ((IBandContent)band).getBandType() == 3;
        }
        return false;
    }

    protected void repeatHeader() throws BirtException {
        if (!this.isFirstLayout) {
            IGroupContent group = (IGroupContent)this.content;
            IBandContent header = group.getHeader();
            if (group.isHeaderRepeat() && header != null && !this.isHeaderBand()) {
                if (header instanceof ITableBandContent) {
                    this.refineBandContent((ITableBandContent)header);
                }
                boolean pageBreak = this.context.allowPageBreak();
                this.context.setAllowPageBreak(false);
                IPageBuffer buffer = this.context.getPageBufferManager();
                boolean isRepeated = buffer.isRepeated();
                buffer.setRepeated(true);
                this.engine.layout((ILayoutManager)this, header, this.emitter);
                buffer.setRepeated(isRepeated);
                this.context.setAllowPageBreak(pageBreak);
            }
        }
        this.isFirstLayout = false;
    }

    private void refineBandContent(ITableBandContent content) {
        if (this.isHeaderRefined) {
            return;
        }
        Collection children = content.getChildren();
        ArrayList<IRowContent> removed = new ArrayList<IRowContent>();
        if (children != null) {
            for (IRowContent rowContent : children) {
                RowDesign rowDesign = (RowDesign)rowContent.getGenerateBy();
                if (rowDesign == null || rowDesign.getRepeatable()) continue;
                removed.add(rowContent);
            }
            children.removeAll(removed);
        }
        this.isHeaderRefined = true;
    }

    protected boolean layoutChildren() throws BirtException {
        this.repeatHeader();
        boolean hasNext = super.layoutChildren();
        return hasNext;
    }
}

