/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.series;

import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.component.Dial;
import org.eclipse.birt.chart.model.type.DialSeries;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.GridAttributesComposite;
import org.eclipse.birt.chart.ui.swt.composites.IntegerSpinControl;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class DialTickSheet
extends AbstractPopupSheet
implements Listener {
    private transient GridAttributesComposite gacMajor = null;
    private transient GridAttributesComposite gacMinor = null;
    private transient Label lblGridCount = null;
    private transient IntegerSpinControl iscGridCount = null;
    private transient DialSeries series;

    public DialTickSheet(String title, ChartWizardContext context, DialSeries series) {
        super(title, context, false);
        this.series = series;
    }

    protected Composite getComponent(Composite parent) {
        GridLayout glContent = new GridLayout();
        glContent.numColumns = 2;
        glContent.marginHeight = 7;
        glContent.marginWidth = 7;
        glContent.verticalSpacing = 5;
        Composite cmpContent = new Composite(parent, 0);
        cmpContent.setLayout((Layout)glContent);
        FillLayout flMajor = new FillLayout();
        FillLayout flMinor = new FillLayout();
        Group grpMajor = new Group(cmpContent, 0);
        GridData gdGRPMajor = new GridData(768);
        grpMajor.setLayoutData((Object)gdGRPMajor);
        grpMajor.setText(Messages.getString("OrthogonalSeriesDataSheetImpl.Lbl.MajorGrid"));
        grpMajor.setLayout((Layout)flMajor);
        this.gacMajor = new GridAttributesComposite((Composite)grpMajor, 0, this.getContext(), this.getDialForProcessing().getMajorGrid(), false);
        this.gacMajor.addListener(this);
        Group grpMinor = new Group(cmpContent, 0);
        GridData gdGRPMinor = new GridData(768);
        grpMinor.setLayoutData((Object)gdGRPMinor);
        grpMinor.setText(Messages.getString("OrthogonalSeriesDataSheetImpl.Lbl.MinorGrid"));
        grpMinor.setLayout((Layout)flMinor);
        this.gacMinor = new GridAttributesComposite((Composite)grpMinor, 0, this.getContext(), this.getDialForProcessing().getMinorGrid(), false);
        this.gacMinor.addListener(this);
        Composite cmpGridCount = new Composite(cmpContent, 0);
        GridData gdCMPGridCount = new GridData(768);
        gdCMPGridCount.horizontalSpan = 2;
        cmpGridCount.setLayoutData((Object)gdCMPGridCount);
        cmpGridCount.setLayout((Layout)new GridLayout(2, false));
        this.lblGridCount = new Label(cmpGridCount, 0);
        this.lblGridCount.setText(Messages.getString("OrthogonalSeriesDataSheetImpl.Lbl.MinorGridCount"));
        this.iscGridCount = new IntegerSpinControl(cmpGridCount, 0, this.getDialForProcessing().getScale().getMinorGridsPerUnit());
        GridData gdISCGridCount = new GridData(768);
        this.iscGridCount.setLayoutData(gdISCGridCount);
        this.iscGridCount.addListener(this);
        this.setState(this.getDialForProcessing().getMinorGrid().getTickAttributes().isVisible());
        return cmpContent;
    }

    public void handleEvent(Event event) {
        if (((Object)((Object)this.gacMajor)).equals(event.widget)) {
            switch (event.type) {
                case 6: {
                    this.getDialForProcessing().getMajorGrid().getTickAttributes().setColor((ColorDefinition)event.data);
                    break;
                }
                case 5: {
                    this.getDialForProcessing().getMajorGrid().setTickStyle((TickStyle)event.data);
                    break;
                }
                case 7: {
                    this.getDialForProcessing().getMajorGrid().getTickAttributes().setVisible(((Boolean)event.data).booleanValue());
                }
            }
        } else if (((Object)((Object)this.gacMinor)).equals(event.widget)) {
            switch (event.type) {
                case 6: {
                    this.getDialForProcessing().getMinorGrid().getTickAttributes().setColor((ColorDefinition)event.data);
                    break;
                }
                case 5: {
                    this.getDialForProcessing().getMinorGrid().setTickStyle((TickStyle)event.data);
                    break;
                }
                case 7: {
                    this.getDialForProcessing().getMinorGrid().getTickAttributes().setVisible(((Boolean)event.data).booleanValue());
                    this.setState(this.getDialForProcessing().getMinorGrid().getTickAttributes().isVisible());
                }
            }
        } else if (event.widget.equals((Object)this.iscGridCount)) {
            this.getDialForProcessing().getScale().setMinorGridsPerUnit(((Integer)event.data).intValue());
        }
    }

    public Dial getDialForProcessing() {
        return this.series.getDial();
    }

    private void setState(boolean enabled) {
        this.lblGridCount.setEnabled(enabled);
        this.iscGridCount.setEnabled(enabled);
    }
}

