/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.model.data.impl.SeriesGroupingImpl;
import org.eclipse.birt.chart.ui.swt.composites.GroupSortingDialog;
import org.eclipse.birt.chart.ui.swt.composites.SeriesGroupingComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YOptionalGroupSortingDialog
extends GroupSortingDialog {
    public YOptionalGroupSortingDialog(Shell shell, ChartWizardContext wizardContext, SeriesDefinition sd, boolean disableAggregation) {
        super(shell, wizardContext, sd, disableAggregation);
    }

    @Override
    protected Set<String> getSortKeySet() {
        LinkedHashSet<String> exprSet = new LinkedHashSet<String>();
        exprSet.addAll(this.getYGroupingExpressions());
        exprSet.addAll(this.getValueSeriesExpressions());
        return exprSet;
    }

    @Override
    public void createSortArea(Composite parent) {
        super.createSortArea(parent);
        if (!this.isYGroupingEnabled()) {
            this.cmpSortArea.setEnabled(false);
            this.lblSorting.setEnabled(false);
            this.cmbSorting.setEnabled(false);
        }
    }

    @Override
    protected SeriesGroupingComposite createSeriesGroupingComposite(Composite parent) {
        SeriesGrouping grouping = this.getSeriesDefinitionForProcessing().getQuery().getGrouping();
        if (grouping == null) {
            grouping = SeriesGroupingImpl.create();
            this.getSeriesDefinitionForProcessing().getQuery().setGrouping(grouping);
        }
        YSeriesGroupingComposite sgc = new YSeriesGroupingComposite(parent, 0, grouping, this.fEnableAggregation, this.wizardContext, null);
        sgc.setGroupingButtionEnabled(false);
        return sgc;
    }

    protected Set<String> getYGroupingExpressions() {
        LinkedHashSet<String> exprSet = new LinkedHashSet<String>();
        Chart chart = this.wizardContext.getModel();
        if (chart instanceof ChartWithAxes) {
            ChartWithAxes cwa = (ChartWithAxes)chart;
            Axis axPrimaryBase = cwa.getPrimaryBaseAxes()[0];
            Axis[] axisArray = cwa.getOrthogonalAxes(axPrimaryBase, true);
            int n = axisArray.length;
            int n2 = 0;
            while (n2 < n) {
                Axis axOrthogonal = axisArray[n2];
                for (SeriesDefinition orthoSD : axOrthogonal.getSeriesDefinitions()) {
                    if (orthoSD.getQuery() == null || orthoSD.getQuery().getDefinition() == null) continue;
                    exprSet.add(orthoSD.getQuery().getDefinition());
                }
                ++n2;
            }
        } else {
            ChartWithoutAxes cwoa = (ChartWithoutAxes)chart;
            for (SeriesDefinition sd : cwoa.getSeriesDefinitions()) {
                for (SeriesDefinition orthSD : sd.getSeriesDefinitions()) {
                    if (orthSD.getQuery() == null || orthSD.getQuery().getDefinition() == null) continue;
                    exprSet.add(orthSD.getQuery().getDefinition());
                }
            }
        }
        return exprSet;
    }

    class YSeriesGroupingComposite
    extends SeriesGroupingComposite {
        public YSeriesGroupingComposite(Composite parent, int style, SeriesGrouping grouping, boolean aggEnabled, ChartWizardContext context, String title) {
            super(parent, style, grouping, aggEnabled, context, title);
        }

        protected void setGroupingButtonSelection() {
            Query query = YOptionalGroupSortingDialog.this.getSeriesDefinitionForProcessing().getQuery();
            if (query != null && query.getDefinition() != null && !"".equals(query.getDefinition())) {
                this.btnEnabled.setSelection(true);
            } else {
                this.btnEnabled.setSelection(false);
            }
        }
    }
}

