/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.document;

import com.lowagie.text.DocWriter;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import java.io.IOException;
import java.io.OutputStream;

public class RtfProtectionSetting
extends RtfElement {
    private static final byte[] FORMPROT = DocWriter.getISOBytes("\\formprot");
    private static final byte[] REVPROT = DocWriter.getISOBytes("\\revprot");
    private static final byte[] ANNOTPROT = DocWriter.getISOBytes("\\annotprot");
    private static final byte[] READPROT = DocWriter.getISOBytes("\\readprot");
    private static final byte[] PROTLEVEL = DocWriter.getISOBytes("\\protlevel");
    private static final byte[] ENFORCEPROT = DocWriter.getISOBytes("\\enforceprot");
    private static final byte[] READONLYRECOMMENDED = DocWriter.getISOBytes("\\readonlyrecommended");

    public RtfProtectionSetting(RtfDocument rtfDocument) {
        super(rtfDocument);
    }

    public void writeContent(OutputStream outputStream) throws IOException {
    }

    public void writeDefinition(OutputStream outputStream) throws IOException {
        if (this.document.getDocumentSettings().isDocumentProtected()) {
            switch (this.document.getDocumentSettings().getProtectionLevelRaw()) {
                case 4: {
                    outputStream.write(FORMPROT);
                    break;
                }
                case 2: {
                    outputStream.write(ANNOTPROT);
                    break;
                }
                case 1: {
                    outputStream.write(REVPROT);
                    break;
                }
                case 8: {
                    outputStream.write(ANNOTPROT);
                    outputStream.write(READPROT);
                }
            }
            outputStream.write(ENFORCEPROT);
            outputStream.write(49);
            outputStream.write(PROTLEVEL);
            outputStream.write(this.document.getDocumentSettings().getProtectionLevelBytes());
        }
        if (this.document.getDocumentSettings().getReadOnlyRecommended()) {
            outputStream.write(READONLYRECOMMENDED);
            outputStream.write(DELIMITER);
        }
    }
}

