/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pdf;

import com.lowagie.text.pdf.PdfTemplate;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.impl.Action;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.pdf.PDFPage;
import org.eclipse.birt.report.engine.emitter.pdf.PDFPageDevice;
import org.eclipse.birt.report.engine.layout.emitter.IPageDevice;
import org.eclipse.birt.report.engine.layout.emitter.PageDeviceRender;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.IContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.IImageArea;
import org.eclipse.birt.report.engine.nLayout.area.ITemplateArea;
import org.eclipse.birt.report.engine.nLayout.area.ITextArea;
import org.eclipse.birt.report.engine.nLayout.area.style.TextStyle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class PDFRender
extends PageDeviceRender {
    private OutputStream output = null;
    private PDFPage currentPage = null;
    private boolean isTotalPage = false;
    private PDFPageDevice currentPageDevice = null;
    private HashSet bookmarks = new HashSet();

    public PDFRender(IEmitterServices services) throws EngineException {
        this.initialize(services);
    }

    public IPageDevice createPageDevice(String title, String author, String subject, String comments, IReportContext context, IReportContent report) throws Exception {
        this.currentPageDevice = new PDFPageDevice(this.output, title, author, subject, comments, context, report);
        return this.currentPageDevice;
    }

    public String getOutputFormat() {
        return "pdf";
    }

    protected void newPage(IContainerArea page) {
        super.newPage(page);
        this.currentPage = (PDFPage)this.pageGraphic;
    }

    public void visitImage(IImageArea imageArea) {
        int imageX = this.currentX + this.getX((IArea)imageArea);
        int imageY = this.currentY + this.getY((IArea)imageArea);
        super.visitImage(imageArea);
        this.createBookmark((IArea)imageArea, imageX, imageY);
        this.createHyperlink((IArea)imageArea, imageX, imageY);
    }

    public void visitText(ITextArea textArea) {
        super.visitText(textArea);
        int x = this.currentX + this.getX((IArea)textArea);
        int y = this.currentY + this.getY((IArea)textArea);
        this.createBookmark((IArea)textArea, x, y);
        this.createHyperlink((IArea)textArea, x, y);
    }

    public void visitAutoText(ITemplateArea templateArea) {
        super.visitAutoText(templateArea);
        int x = this.currentX + this.getX((IArea)templateArea);
        int y = this.currentY + this.getY((IArea)templateArea);
        this.createTotalPageTemplate(x, y, this.getWidth((IArea)templateArea), this.getHeight((IArea)templateArea), this.scale);
    }

    public void setTotalPage(ITextArea totalPage) {
        super.setTotalPage(totalPage);
        this.isTotalPage = true;
        HashMap<Float, PdfTemplate> map = ((PDFPageDevice)this.pageDevice).getTemplateMap();
        if (!map.isEmpty()) {
            float scaleCache = this.scale;
            for (Float s : map.keySet()) {
                PdfTemplate template = map.get(s);
                if (template == null) continue;
                this.scale = s.floatValue();
                this.drawText(totalPage);
            }
            this.scale = scaleCache;
        }
        this.isTotalPage = false;
    }

    public void end(IReportContent rc) {
        this.createTOC();
        super.end(rc);
    }

    protected void drawContainer(IContainerArea container) {
        super.drawContainer(container);
        int x = this.currentX + this.getX((IArea)container);
        int y = this.currentY + this.getY((IArea)container);
        this.createBookmark((IArea)container, x, y);
        this.createHyperlink((IArea)container, x, y);
    }

    private void initialize(IEmitterServices services) throws EngineException {
        this.services = services;
        this.reportRunnable = services.getReportRunnable();
        if (this.reportRunnable != null) {
            this.reportDesign = (ReportDesignHandle)this.reportRunnable.getDesignHandle();
        }
        this.context = services.getReportContext();
        this.output = EmitterUtil.getOuputStream((IEmitterServices)services, (String)"report.pdf");
    }

    protected void drawTextAt(ITextArea text, int x, int y, int width, int height, TextStyle textInfo) {
        if (this.isTotalPage) {
            this.currentPage.drawTotalPage(text.getText(), x, y, width, height, textInfo, this.scale);
        } else {
            this.currentPage.drawText(text.getText(), x, y, width, height, textInfo);
        }
    }

    private void createHyperlink(IArea area, int x, int y) {
        IHyperlinkAction hlAction = area.getAction();
        if (hlAction != null) {
            try {
                String systemId = this.reportRunnable == null ? null : this.reportRunnable.getReportName();
                int width = this.getWidth(area);
                int height = this.getHeight(area);
                String bookmark = hlAction.getBookmark();
                String targetWindow = hlAction.getTargetWindow();
                int type = hlAction.getType();
                Action act = new Action(systemId, hlAction);
                String link = null;
                IHTMLActionHandler actionHandler = null;
                Object ac = this.services.getOption("actionHandler");
                if (ac != null && ac instanceof IHTMLActionHandler) {
                    actionHandler = (IHTMLActionHandler)ac;
                }
                link = actionHandler != null ? actionHandler.getURL((IAction)act, this.context) : hlAction.getHyperlink();
                switch (type) {
                    case 2: {
                        this.currentPage.createHyperlink(link, bookmark, targetWindow, type, x, y, width, height);
                        break;
                    }
                    case 1: {
                        this.currentPage.createHyperlink(link, (String)null, targetWindow, type, x, y, width, height);
                        break;
                    }
                    case 3: {
                        this.currentPage.createHyperlink(link, (String)null, targetWindow, type, x, y, width, height);
                    }
                }
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    private void createBookmark(IArea area, int x, int y) {
        String bookmark = area.getBookmark();
        if (bookmark != null) {
            int height = this.getHeight(area);
            int width = this.getWidth(area);
            this.currentPage.createBookmark(bookmark, x, y, width, height);
            this.bookmarks.add(bookmark);
        }
    }

    private void createTOC() {
        this.currentPageDevice.createTOC(this.bookmarks);
    }

    private void createTotalPageTemplate(int x, int y, int width, int height, float scale) {
        this.currentPage.createTotalPageTemplate(x, y, width, height, scale);
    }
}

