/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.dbprofile.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyAdapter {
    private static final String EMPTY_STRING = "";
    private static Map<String, String> sm_adaptableNames;

    private PropertyAdapter() {
    }

    public static Properties adaptToDbProfilePropertyNames(Properties connProperties) {
        Properties profileProps = new Properties();
        profileProps.putAll((Map<?, ?>)connProperties);
        PropertyAdapter.adaptToFullPropertyNames(profileProps);
        String dbConnPropValues = profileProps.getProperty("org.eclipse.datatools.connectivity.db.connectionProperties");
        if (dbConnPropValues == null) {
            profileProps.setProperty("org.eclipse.datatools.connectivity.db.connectionProperties", EMPTY_STRING);
        }
        return profileProps;
    }

    public static Properties adaptToDataSourcePropertyNames(Properties profileProperties) {
        Properties sourceProps = new Properties();
        sourceProps.putAll((Map<?, ?>)profileProperties);
        PropertyAdapter.adaptToOdaPropertyNames(sourceProps);
        sourceProps.remove("isTransient");
        return sourceProps;
    }

    private static void adaptToFullPropertyNames(Properties profilePros) {
        for (Map.Entry<String, String> propertyNames : PropertyAdapter.getAdaptableNames().entrySet()) {
            String currentName = propertyNames.getValue();
            String newName = propertyNames.getKey();
            PropertyAdapter.changePropertyName(profilePros, currentName, newName);
        }
    }

    private static void adaptToOdaPropertyNames(Properties profilePros) {
        for (Map.Entry<String, String> propertyNames : PropertyAdapter.getAdaptableNames().entrySet()) {
            String currentName = propertyNames.getKey();
            String newName = propertyNames.getValue();
            PropertyAdapter.changePropertyName(profilePros, currentName, newName);
        }
    }

    private static void changePropertyName(Properties profilePros, String currentName, String newName) {
        Object propValue = profilePros.remove(currentName);
        if (propValue != null) {
            profilePros.put(newName, propValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, String> getAdaptableNames() {
        if (sm_adaptableNames != null) return sm_adaptableNames;
        Class<PropertyAdapter> clazz = PropertyAdapter.class;
        synchronized (PropertyAdapter.class) {
            if (sm_adaptableNames != null) return sm_adaptableNames;
            sm_adaptableNames = new HashMap<String, String>(6);
            String fullPropName = "org.eclipse.datatools.connectivity.db.databaseName";
            sm_adaptableNames.put(fullPropName, PropertyAdapter.convertToOdaPropertyName(fullPropName));
            fullPropName = "org.eclipse.datatools.connectivity.db.username";
            sm_adaptableNames.put(fullPropName, PropertyAdapter.convertToOdaPropertyName(fullPropName));
            fullPropName = "org.eclipse.datatools.connectivity.db.password";
            sm_adaptableNames.put(fullPropName, PropertyAdapter.convertToOdaPropertyName(fullPropName));
            fullPropName = "org.eclipse.datatools.connectivity.db.URL";
            sm_adaptableNames.put(fullPropName, PropertyAdapter.convertToOdaPropertyName(fullPropName));
            fullPropName = "org.eclipse.datatools.connectivity.db.driverClass";
            sm_adaptableNames.put(fullPropName, PropertyAdapter.convertToOdaPropertyName(fullPropName));
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_adaptableNames;
        }
    }

    private static String convertToOdaPropertyName(String fullPropName) {
        return fullPropName.substring(fullPropName.lastIndexOf(46) + 1);
    }
}

