/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.preview;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.FunctionMapper;
import javax.servlet.jsp.el.VariableResolver;
import org.apache.commons.el.ExpressionEvaluatorImpl;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.jsf.common.ui.internal.utils.ResourceUtils;
import org.eclipse.jst.jsf.core.internal.tld.LoadBundleUtil;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.jsp.core.el.JSFELParserHelper;
import org.eclipse.jst.pagedesigner.jsp.core.pagevar.IPageVariablesProvider;
import org.eclipse.jst.pagedesigner.jsp.core.pagevar.IVariableInfo;

public class PageExpressionContext {
    private static final Logger _log = PDPlugin.getLogger(PageExpressionContext.class);
    static PageExpressionContext _current;
    List _pageVarProviders = new ArrayList();
    VariableResolver resolver = new SimpleVariableResolver();
    private IProject _prj;

    public PageExpressionContext(IProject prj) {
        this._prj = prj;
    }

    public static void reset() {
        _current = null;
    }

    public static void initialize(IProject prj) {
        _current = new PageExpressionContext(prj);
    }

    public static PageExpressionContext getCurrent() {
        return _current;
    }

    public void pushPageVarProvider(IPageVariablesProvider provider) {
        this._pageVarProviders.add(provider);
    }

    public void popPageVarProvider(IPageVariablesProvider provider) {
        try {
            this._pageVarProviders.remove(this._pageVarProviders.size() - 1);
        }
        catch (Exception ex) {
            _log.info("PageExpressionContext.Info.0", (Throwable)ex);
        }
    }

    public Object evaluateExpression(String expression, Class expectedClass, Map options) throws ELException {
        expression = JSFELParserHelper.toJspElExpression((String)expression);
        ExpressionEvaluatorImpl evaluator = new ExpressionEvaluatorImpl();
        EmptyFunctionMapper mapper = new EmptyFunctionMapper();
        return evaluator.evaluate(expression, expectedClass, this.resolver, (FunctionMapper)mapper);
    }

    static class EmptyFunctionMapper
    implements FunctionMapper {
        EmptyFunctionMapper() {
        }

        public Method resolveFunction(String arg0, String arg1) {
            return null;
        }
    }

    class SimpleVariableResolver
    implements VariableResolver {
        SimpleVariableResolver() {
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object resolveVariable(String varName) throws ELException {
            int k = PageExpressionContext.this._pageVarProviders.size() - 1;
            while (true) {
                IVariableInfo[] vars;
                if (k < 0) {
                    throw new ELException("Can't find: " + varName);
                }
                IPageVariablesProvider _pageVars = (IPageVariablesProvider)PageExpressionContext.this._pageVarProviders.get(k);
                if (_pageVars != null && (vars = _pageVars.getBeanInfos()) != null) {
                    int i = 0;
                    while (i < vars.length) {
                        if (varName.equals(vars[i].getName()) && vars[i].getMode() == 3) {
                            Properties properties;
                            String resourceName = vars[i].getTypeInfoString();
                            IStorage s = null;
                            try {
                                s = LoadBundleUtil.getLoadBundleResource((IProject)PageExpressionContext.this._prj, (String)resourceName);
                            }
                            catch (CoreException ex) {
                                _log.info("PageExpressionContext.Info.0", (Throwable)ex);
                            }
                            if (s == null) {
                                throw new ELException();
                            }
                            BufferedInputStream input = null;
                            try {
                                input = new BufferedInputStream(s.getContents());
                                Properties p = new Properties();
                                p.load(input);
                                properties = p;
                            }
                            catch (CoreException e) {
                                try {
                                    throw new ELException((Throwable)e);
                                    catch (IOException e2) {
                                        throw new ELException((Throwable)e2);
                                    }
                                }
                                catch (Throwable throwable) {
                                    ResourceUtils.ensureClosed(input);
                                    throw throwable;
                                }
                            }
                            ResourceUtils.ensureClosed((InputStream)input);
                            return properties;
                        }
                        ++i;
                    }
                }
                --k;
            }
        }
    }
}

