/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core.launching;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptStackFrame;
import org.eclipse.wst.jsdt.debug.core.model.IScript;
import org.eclipse.wst.jsdt.debug.internal.core.JavaScriptDebugPlugin;

public class JavaScriptSourceLookupParticipant
extends AbstractSourceLookupParticipant {
    static final Object[] NO_SOURCE = new Object[0];

    public String getSourceName(Object object) throws CoreException {
        if (object instanceof IJavaScriptStackFrame) {
            return ((IJavaScriptStackFrame)object).getSourceName();
        }
        if (object instanceof IScript) {
            return URIUtil.lastSegment((URI)((IScript)object).sourceURI());
        }
        return null;
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        URI sourceURI = this.getSourceURI(object);
        if (sourceURI != null) {
            IFile file;
            IWorkspaceRoot workspaceRoot;
            URI workspaceURI;
            URI workspaceRelativeURI;
            if (!(sourceURI.isAbsolute() && !"file".equals(sourceURI.getScheme()) || (workspaceRelativeURI = (workspaceURI = (workspaceRoot = ResourcesPlugin.getWorkspace().getRoot()).getRawLocationURI()).relativize(sourceURI)).isAbsolute() || (file = (IFile)workspaceRoot.findMember((IPath)new Path(workspaceRelativeURI.getPath()), false)) == null)) {
                return new IFile[]{file};
            }
            return this.showExternalSource(this.getSource(object), sourceURI);
        }
        return NO_SOURCE;
    }

    private String getSource(Object object) {
        if (object instanceof IJavaScriptStackFrame) {
            IJavaScriptStackFrame jframe = (IJavaScriptStackFrame)object;
            return jframe.getSource();
        }
        if (object instanceof IScript) {
            IScript script = (IScript)object;
            return script.source();
        }
        return null;
    }

    private URI getSourceURI(Object object) {
        if (object instanceof IJavaScriptStackFrame) {
            IJavaScriptStackFrame jframe = (IJavaScriptStackFrame)object;
            return URI.create(jframe.getSourcePath());
        }
        if (object instanceof IScript) {
            IScript script = (IScript)object;
            return script.sourceURI();
        }
        return null;
    }

    private Object[] showExternalSource(String source, URI uri) {
        try {
            IFile file;
            IProject project = JavaScriptDebugPlugin.getExternalSourceProject(true);
            String filename = URIUtil.lastSegment((URI)uri);
            String uriHash = Integer.toString(uri.toString().hashCode());
            String sourceHash = Integer.toString(source.hashCode());
            IPath path = new Path(uriHash).append(sourceHash).append(filename);
            if (path.getFileExtension() == null) {
                path = path.addFileExtension("js");
            }
            if (!(file = project.getFile(path)).isAccessible()) {
                IProject folder = project;
                int i = 0;
                while (i < path.segmentCount() - 1) {
                    IFolder f = folder.getFolder((IPath)new Path(path.segment(i)));
                    if (!f.exists()) {
                        f.create(true, true, null);
                    }
                    folder = f;
                    ++i;
                }
                file.create((InputStream)new ByteArrayInputStream(source.getBytes()), true, null);
            }
            if (JavaScriptDebugPlugin.getExternalScriptPath(path) == null) {
                JavaScriptDebugPlugin.addExternalScriptPath(path, uri.toString());
            }
            return new Object[]{file};
        }
        catch (CoreException ce) {
            JavaScriptDebugPlugin.log(ce);
            return NO_SOURCE;
        }
    }

    public boolean isFindDuplicates() {
        return true;
    }
}

