/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.wizards.schemagen;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jpt.jaxb.core.internal.SchemaGenerator;
import org.eclipse.jpt.jaxb.ui.internal.JptJaxbUiMessages;
import org.eclipse.jpt.jaxb.ui.internal.filters.ContainerFilter;
import org.eclipse.jpt.jaxb.ui.internal.filters.EmptyInnerPackageFilter;
import org.eclipse.jpt.jaxb.ui.internal.filters.NonArchiveOrExternalElementFilter;
import org.eclipse.jpt.jaxb.ui.internal.filters.NonContainerFilter;
import org.eclipse.jpt.jaxb.ui.internal.filters.NonJavaElementFilter;
import org.eclipse.jpt.jaxb.ui.internal.wizards.schemagen.AbstractJarDestinationWizardPage;
import org.eclipse.jpt.jaxb.ui.internal.wizards.schemagen.CheckboxTreeAndListGroup;
import org.eclipse.jpt.jaxb.ui.internal.wizards.schemagen.ProjectWizardPage;
import org.eclipse.jpt.utility.internal.ArrayTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaGeneratorWizardPage
extends AbstractJarDestinationWizardPage {
    private IStructuredSelection initialSelection;
    private IJavaProject targetProject;
    private SettingsGroup settingsGroup;
    private Button usesMoxyCheckBox;
    private boolean usesMoxy;
    public static String JPT_ECLIPSELINK_UI_PLUGIN_ID = "org.eclipse.jpt.eclipselink.ui";
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 480;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 150;
    public static final String HELP_CONTEXT_ID = "org.eclipse.jpt.ui.wizard_jaxbschema_classes";

    public SchemaGeneratorWizardPage(IStructuredSelection selection) {
        super("JAXB Schema Generator", selection, null);
        this.initialSelection = selection;
        this.setUsesMoxy(false);
        this.setTitle(JptJaxbUiMessages.SchemaGeneratorWizardPage_title);
        this.setDescription(JptJaxbUiMessages.SchemaGeneratorWizardPage_desc);
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        this.setControl(this.buildTopLevelControl(parent));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.updateTargetProject();
        this.setDefaultSchemaFile();
        this.updateInputGroupTreeFilter();
        this.updateUsesMoxy(this.jptEclipseLinkBundleExists() && this.moxyIsOnClasspath());
        this.usesMoxyCheckBox.setVisible(this.jptEclipseLinkBundleExists() && !this.moxyIsOnClasspath());
        this.validateProjectClasspath();
        this.giveFocusToDestination();
    }

    protected void setDefaultSchemaFile() {
        String defaultSchemaName = String.valueOf(this.targetProject.getProject().getName()) + ".xsd";
        this.settingsGroup.schemaFileText.setText(defaultSchemaName);
        this.settingsGroup.schemaFileText.setSelection(0, defaultSchemaName.length());
    }

    public boolean isPageComplete() {
        boolean complete = this.validateDestinationGroup();
        if (complete && (complete = this.validateSourceGroup())) {
            this.validateProjectClasspath();
        }
        return complete;
    }

    public void setPreviousPage(IWizardPage page) {
        super.setPreviousPage(page);
        if (this.getControl() != null) {
            this.updatePageCompletion();
        }
    }

    protected IJavaProject getJavaProject() {
        return this.targetProject;
    }

    protected String getSchemaPath() {
        return this.settingsGroup.getSchemaPath();
    }

    protected Object[] getAllCheckedItems() {
        return ArrayTools.array(this.getInputGroup().getAllCheckedListItems());
    }

    protected boolean usesMoxy() {
        return this.usesMoxy;
    }

    protected void updatePageCompletion() {
        super.updatePageCompletion();
    }

    protected boolean validateDestinationGroup() {
        boolean complete = this.targetSchemaIsEmpty();
        if (!complete) {
            this.setErrorMessage(JptJaxbUiMessages.SchemaGeneratorWizardPage_errorNoSchema);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected boolean validateSourceGroup() {
        if (this.getAllCheckedItems().length == 0) {
            if (this.getErrorMessage() == null) {
                this.setErrorMessage(JptJaxbUiMessages.SchemaGeneratorWizardPage_errorNoPackage);
            }
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private void validateProjectClasspath() {
        this.setMessage(null);
        if (!this.genericJaxbIsOnClasspath()) {
            this.displayWarning(JptJaxbUiMessages.SchemaGeneratorWizardPage_jaxbLibrariesNotAvailable);
        } else if (this.usesMoxy() && !this.moxyIsOnClasspath()) {
            this.displayWarning(JptJaxbUiMessages.SchemaGeneratorWizardPage_moxyLibrariesNotAvailable);
        }
    }

    private boolean genericJaxbIsOnClasspath() {
        try {
            String className = SchemaGenerator.JAXB_GENERIC_SCHEMA_GEN_CLASS;
            IType genClass = this.targetProject.findType(className);
            return genClass != null;
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    private Control buildTopLevelControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, HELP_CONTEXT_ID);
        this.settingsGroup = new SettingsGroup(composite);
        this.usesMoxyCheckBox = this.buildUsesMoxyCheckBox(composite);
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private void updateTargetProject() {
        IWizardPage previousPage = this.getPreviousPage();
        if (previousPage instanceof ProjectWizardPage) {
            this.targetProject = ((ProjectWizardPage)previousPage).getProject();
        } else if (this.initialSelection != null && !this.initialSelection.isEmpty()) {
            this.targetProject = this.getProjectFromInitialSelection();
        }
    }

    private void updateInputGroupTreeFilter() {
        this.getInputGroup().addTreeFilter(new NonContainerFilter(this.targetProject.getProject().getName()));
    }

    private IJavaProject getProjectFromInitialSelection() {
        IJavaProject project = null;
        Object firstElement = this.initialSelection.getFirstElement();
        if (firstElement instanceof IJavaElement) {
            IJavaElement javaElement = (IJavaElement)firstElement;
            int type = javaElement.getElementType();
            if (type == 2) {
                project = (IJavaProject)javaElement;
            } else if (type == 4) {
                project = ((IPackageFragment)javaElement).getJavaProject();
            }
        }
        return project;
    }

    private boolean targetSchemaIsEmpty() {
        return !StringTools.stringIsEmpty((String)this.getSchemaPath());
    }

    private boolean jptEclipseLinkBundleExists() {
        return this.getJptEclipseLinkBundle() != null;
    }

    private Bundle getJptEclipseLinkBundle() {
        return Platform.getBundle((String)JPT_ECLIPSELINK_UI_PLUGIN_ID);
    }

    private void setUsesMoxy(boolean usesMoxy) {
        this.usesMoxy = usesMoxy;
    }

    private void updateUsesMoxy(boolean usesMoxy) {
        this.setUsesMoxy(usesMoxy);
        this.usesMoxyCheckBox.setSelection(this.usesMoxy());
        this.validateProjectClasspath();
    }

    private boolean moxyIsOnClasspath() {
        try {
            String className = SchemaGenerator.JAXB_ECLIPSELINK_SCHEMA_GEN_CLASS;
            IType genClass = this.targetProject.findType(className);
            return genClass != null;
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    private void displayWarning(String message) {
        this.setMessage(message, 2);
    }

    private CheckboxTreeAndListGroup getInputGroup() {
        return this.settingsGroup.inputGroup;
    }

    protected Iterator<?> getSelectedResourcesIterator() {
        return this.getInputGroup().getAllCheckedListItems();
    }

    protected void update() {
        this.updatePageCompletion();
    }

    public final void saveWidgetValues() {
    }

    protected void internalSaveWidgetValues() {
    }

    protected void restoreWidgetValues() {
    }

    protected void initializeJarPackage() {
    }

    protected void giveFocusToDestination() {
        this.settingsGroup.giveFocusToDestination();
    }

    private Button buildUsesMoxyCheckBox(Composite parent) {
        Button checkBox = new Button(parent, 32);
        GridData gridData = new GridData();
        gridData.verticalIndent = 10;
        checkBox.setLayoutData((Object)gridData);
        checkBox.setText(JptJaxbUiMessages.ClassesGeneratorWizardPage_usesMoxyImplementation);
        checkBox.setSelection(this.usesMoxy());
        checkBox.addSelectionListener(this.buildUsesMoxySelectionListener());
        return checkBox;
    }

    private SelectionListener buildUsesMoxySelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                SchemaGeneratorWizardPage.this.updateUsesMoxy(SchemaGeneratorWizardPage.this.usesMoxyCheckBox.getSelection());
                SchemaGeneratorWizardPage.this.validateProjectClasspath();
            }
        };
    }

    private class SettingsGroup {
        private CheckboxTreeAndListGroup inputGroup;
        private Text schemaFileText;

        private SettingsGroup(Composite parent) {
            SchemaGeneratorWizardPage.this.initializeDialogUnits((Control)parent);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(768));
            this.buildSchemaComposite(composite);
            SchemaGeneratorWizardPage.this.createPlainLabel(composite, JptJaxbUiMessages.SchemaGeneratorWizardPage_packages);
            this.inputGroup = this.createInputGroup(composite);
            if (SchemaGeneratorWizardPage.this.initialSelection != null) {
                BusyIndicator.showWhile((Display)parent.getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        SettingsGroup.this.setupBasedOnInitialSelections();
                    }
                });
            }
        }

        protected void buildSchemaComposite(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(3, false);
            layout.marginWidth = 0;
            layout.marginTop = 0;
            layout.marginBottom = 10;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(768));
            this.buildLabel(composite, JptJaxbUiMessages.SchemaGeneratorWizardPage_shemaLocation);
            this.schemaFileText = this.buildSchemaText(composite);
            this.buildBrowseButton(composite, 1);
        }

        protected String getSchemaPath() {
            return this.schemaFileText.getText();
        }

        protected void giveFocusToDestination() {
            this.schemaFileText.setFocus();
        }

        private Label buildLabel(Composite parent, String text) {
            Label label = new Label(parent, 16384);
            label.setText(text);
            label.setLayoutData((Object)new GridData());
            return label;
        }

        private Text buildSchemaText(Composite parent) {
            Text text = new Text(parent, 2048);
            GridData gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            text.setLayoutData((Object)gridData);
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SchemaGeneratorWizardPage.this.updatePageCompletion();
                }
            });
            return text;
        }

        private Button buildBrowseButton(Composite parent, int horizontalSpan) {
            Button browseButton = new Button(parent, 8);
            browseButton.setText(JptJaxbUiMessages.SchemaGeneratorWizardPage_browse);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.horizontalSpan = horizontalSpan;
            browseButton.setLayoutData((Object)gridData);
            browseButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    String fileName = SettingsGroup.this.promptFile();
                    if (!StringTools.stringIsEmpty((String)fileName)) {
                        SettingsGroup.this.schemaFileText.setText(SettingsGroup.this.makeRelativeToProjectPath(fileName));
                    }
                }
            });
            return browseButton;
        }

        private String promptFile() {
            FileDialog dialog = new FileDialog(SchemaGeneratorWizardPage.this.getShell());
            dialog.setText(JptJaxbUiMessages.SchemaGeneratorWizardPage_chooseSchemaDialogTitle);
            dialog.setFilterPath(this.getFilterPath());
            dialog.setFilterExtensions(new String[]{"*.xsd"});
            String filePath = dialog.open();
            return filePath != null ? filePath : null;
        }

        protected CheckboxTreeAndListGroup createInputGroup(Composite parent) {
            int labelFlags = 272;
            StandardJavaElementContentProvider treeContentProvider = new StandardJavaElementContentProvider(){

                public boolean hasChildren(Object element) {
                    return !(element instanceof IPackageFragment) && super.hasChildren(element);
                }
            };
            DecoratingLabelProvider provider = new DecoratingLabelProvider((ILabelProvider)new JavaElementLabelProvider(labelFlags), (ILabelDecorator)new ProblemsLabelDecorator(null));
            CheckboxTreeAndListGroup checkboxTreeGroup = new CheckboxTreeAndListGroup(parent, JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()), (ITreeContentProvider)treeContentProvider, (ILabelProvider)provider, (IStructuredContentProvider)new StandardJavaElementContentProvider(), (ILabelProvider)provider, 0, 480, 150);
            checkboxTreeGroup.addTreeFilter(new EmptyInnerPackageFilter());
            checkboxTreeGroup.setTreeComparator((ViewerComparator)new JavaElementComparator());
            checkboxTreeGroup.setListComparator((ViewerComparator)new JavaElementComparator());
            checkboxTreeGroup.addTreeFilter(new NonJavaElementFilter());
            checkboxTreeGroup.addTreeFilter(new NonArchiveOrExternalElementFilter());
            checkboxTreeGroup.addListFilter(new ContainerFilter());
            checkboxTreeGroup.addListFilter(new NonJavaElementFilter());
            checkboxTreeGroup.getTree().addListener(4, (Listener)SchemaGeneratorWizardPage.this);
            checkboxTreeGroup.getTable().addListener(4, (Listener)SchemaGeneratorWizardPage.this);
            ICheckStateListener listener = new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    SchemaGeneratorWizardPage.this.update();
                }
            };
            checkboxTreeGroup.addCheckStateListener(listener);
            return checkboxTreeGroup;
        }

        private String makeRelativeToProjectPath(String filePath) {
            Path path = new Path(filePath);
            IPath relativePath = path.makeRelativeTo(SchemaGeneratorWizardPage.this.targetProject.getProject().getLocation());
            return relativePath.toOSString();
        }

        private String getFilterPath() {
            return SchemaGeneratorWizardPage.this.targetProject.getProject().getLocation().toOSString();
        }

        private void setupBasedOnInitialSelections() {
            for (Object selectedElement : SchemaGeneratorWizardPage.this.initialSelection) {
                IJavaElement je;
                if (selectedElement instanceof IResource && !((IResource)selectedElement).isAccessible() || selectedElement instanceof IJavaElement && !((IJavaElement)selectedElement).exists()) continue;
                if (selectedElement instanceof ICompilationUnit || selectedElement instanceof IClassFile || selectedElement instanceof IFile) {
                    this.inputGroup.initialCheckListItem(selectedElement);
                    continue;
                }
                if (selectedElement instanceof IFolder && (je = JavaCore.create((IResource)((IResource)selectedElement))) != null && je.exists() && je.getJavaProject().isOnClasspath((IResource)selectedElement)) {
                    selectedElement = je;
                    je.toString();
                }
                this.inputGroup.initialCheckTreeItem(selectedElement);
            }
            TreeItem[] items = this.inputGroup.getTree().getItems();
            int i = 0;
            while (i < items.length && !items[i].getChecked()) {
                ++i;
            }
            if (i < items.length) {
                this.inputGroup.getTree().setSelection(new TreeItem[]{items[i]});
                this.inputGroup.getTree().showSelection();
                this.inputGroup.populateListViewer(items[i].getData());
            }
        }
    }
}

