/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.rulewidgets.detailtabs;

import org.eclipse.ebam.designers.exception.WizardException;
import org.eclipse.ebam.designers.wizards.pages.rulewidgets.detailtabs.RuleEventTabItem;
import org.eclipse.ebam.emf.EbamEventTransactions;
import org.eclipse.ebam.emf.RulesTransactions;
import org.eclipse.ebam.model.entities.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleEventTabFunctions {
    RuleEventTabItem itemSelectedPage;
    private static Logger logger = LoggerFactory.getLogger(RuleEventTabFunctions.class);

    public RuleEventTabFunctions(RuleEventTabItem item) {
        this.itemSelectedPage = item;
    }

    public void addRuleEventSelection(TableItem tableItem) throws Exception {
        String handlerClass;
        String expression;
        logger.debug("IN");
        this.disableRuleEventDetail();
        Double id = (Double)tableItem.getData();
        Event event = new EbamEventTransactions().getEbamEventById(Integer.valueOf(id.intValue()));
        String name = event.getName();
        if (name == null) {
            name = "";
        }
        if ((expression = event.getExpression()) == null) {
            expression = "";
        }
        if ((handlerClass = event.getHandlerClass()) == null) {
            handlerClass = "";
        }
        boolean persist = event.getPersist() != 0;
        this.itemSelectedPage.getNameText().setText(name);
        this.itemSelectedPage.getExpressionText().setText(expression);
        this.itemSelectedPage.getClassText().setText(handlerClass);
        this.itemSelectedPage.getPersistButton().setSelection(persist);
        boolean checked = tableItem.getChecked();
        if (checked) {
            TableItem[] items = this.itemSelectedPage.getRuleEventTable().getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                Double dou = (Double)item.getData();
                if (!dou.equals(id)) {
                    logger.debug("item Event is checked with id: " + id);
                    item.setChecked(false);
                }
                ++i;
            }
        }
        this.setPageAfterRuleEventSelection();
        this.itemSelectedPage.getRuleEventTable().redraw();
        logger.debug("OUT");
    }

    private void setPageAfterRuleEventSelection() {
        this.handleEventButtons(true, true, true);
        this.itemSelectedPage.getButtonSaveValue().setVisible(true);
        this.itemSelectedPage.getNameText().setEditable(true);
    }

    public void eraseRuleEventPush() throws WizardException {
        logger.debug("IN");
        Table table = this.itemSelectedPage.getRuleEventTable();
        int indexSelected = table.getSelectionIndex();
        if (indexSelected != -1) {
            TableItem tableItem = table.getItem(indexSelected);
            Double id = (Double)tableItem.getData();
            try {
                new EbamEventTransactions().deleteEvent(Integer.valueOf(id.intValue()));
                logger.debug("deleted the event with id " + id);
            }
            catch (Exception e) {
                logger.error("error in erasing Event", (Throwable)e);
                throw new WizardException(e, "error in erasing Event");
            }
            table.remove(indexSelected);
            table.redraw();
            this.setPageAfterEraseButtonPush(table);
            this.fillEmptyValues(false);
        }
        logger.debug("OUT");
    }

    private void setPageAfterEraseButtonPush(Table table) {
        table.setSelection(-1);
        this.disableRuleEventDetail();
        this.handleEventButtons(true, false, false);
    }

    public void saveValueButtonPush(Integer ruleIdPar) throws Exception {
        Event event;
        logger.debug("IN");
        boolean updating = true;
        int selectedIndex = this.itemSelectedPage.getRuleEventTable().getSelectionIndex();
        if (selectedIndex != -1) {
            logger.debug("updateing mode ");
            updating = true;
            TableItem itemSel = this.itemSelectedPage.getRuleEventTable().getItem(selectedIndex);
            Double id = (Double)itemSel.getData();
            event = new EbamEventTransactions().getEbamEventById(Integer.valueOf(id.intValue()));
        } else {
            logger.debug("inserting mode ");
            updating = false;
            event = new Event();
        }
        Integer ruleId = this.itemSelectedPage.getSelectedRuleId();
        new RulesTransactions().getRuleById(ruleId);
        String name = this.itemSelectedPage.getNameText().getText();
        String expression = this.itemSelectedPage.getExpressionText().getText();
        String handlerClass = this.itemSelectedPage.getClassText().getText();
        boolean persist = this.itemSelectedPage.getPersistButton().getSelection();
        event.setName(name);
        event.setExpression(expression);
        event.setHandlerClass(handlerClass);
        event.setPersist(persist ? 1 : 0);
        if (!updating) {
            new EbamEventTransactions().createNewEvent(event);
            Table table = this.itemSelectedPage.getRuleEventTable();
            TableItem tableItem = new TableItem(table, 0);
            Double id = event.getEventId();
            tableItem.setData((Object)id);
            tableItem.setText(0, event.getName());
            tableItem.setText(1, event.getExpression());
            logger.debug("inserted the new Event with id " + id);
        } else {
            new EbamEventTransactions().mergeEvent(event);
            TableItem itemSel = this.itemSelectedPage.getRuleEventTable().getItem(selectedIndex);
            itemSel.setText(0, event.getName());
            itemSel.setText(1, event.getExpression());
            logger.debug("updated Event with id " + event.getEventId());
        }
        this.itemSelectedPage.getRuleEventTable().setSelection(-1);
        this.itemSelectedPage.getRuleEventTable().redraw();
        logger.debug("OUT");
    }

    public void addAddButtonPush(Integer thresholdId) throws Exception {
        this.fillEmptyValues(false);
        this.handleEventButtons(true, false, true);
        this.itemSelectedPage.getNameText().setEditable(true);
        this.itemSelectedPage.getRuleEventTable().setSelection(-1);
    }

    public void fillEmptyValues(boolean removeChecked) {
        this.itemSelectedPage.getNameText().setText("");
        this.itemSelectedPage.getExpressionText().setText("");
        this.itemSelectedPage.getClassText().setText("");
        this.itemSelectedPage.getPersistButton().setSelection(false);
        if (removeChecked) {
            TableItem[] items = this.itemSelectedPage.getRuleEventTable().getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                item.setChecked(false);
                ++i;
            }
        }
    }

    public void disableRuleEventDetail() {
        this.itemSelectedPage.getNameText().setEnabled(false);
        this.itemSelectedPage.getExpressionText().setEnabled(false);
        this.itemSelectedPage.getClassText().setEnabled(false);
        this.itemSelectedPage.getPersistButton().setEnabled(false);
    }

    public void enableRuleEventDetail(TableItem tableItem) {
        this.itemSelectedPage.getNameText().setEnabled(true);
        this.itemSelectedPage.getExpressionText().setEnabled(true);
        this.itemSelectedPage.getClassText().setEnabled(true);
        this.itemSelectedPage.getPersistButton().setEnabled(true);
    }

    public void handleEventButtons(boolean add, boolean erase, boolean save) {
        this.itemSelectedPage.getButtonAdd().setEnabled(add);
        this.itemSelectedPage.getButtonErase().setEnabled(erase);
        this.itemSelectedPage.getButtonSaveValue().setVisible(save);
    }
}

