/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.messagewidgets.detailtabs;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ebam.designers.exception.WizardException;
import org.eclipse.ebam.designers.swtutils.SWTUtils;
import org.eclipse.ebam.designers.wizards.pages.messagewidgets.MessagesDetailComposite;
import org.eclipse.ebam.emf.SbiDomainTransactions;
import org.eclipse.ebam.emf.ServiceTransactions;
import org.eclipse.ebam.model.entities.Message;
import org.eclipse.ebam.model.entities.SbiDomain;
import org.eclipse.ebam.model.entities.Service;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageDetailTabItem
extends CTabItem {
    private MessagesDetailComposite messagesDetailComposite;
    private Text nameText;
    private Text descrText;
    private Combo typeCombo;
    private Combo serviceCombo;
    private Text rootElementText;
    private StyledText xmlSchemaText;
    private StyledText xslText;
    private Button startDateButton;
    private Button endDateButton;
    Map<Integer, Service> idToService = new HashMap<Integer, Service>();
    Map<Integer, Integer> indexToServiceId = new HashMap<Integer, Integer>();
    Map<Integer, Integer> serviceIdToIndex = new HashMap<Integer, Integer>();
    Map<Integer, SbiDomain> idToDomain = new HashMap<Integer, SbiDomain>();
    Map<Integer, Integer> indexToDomainId = new HashMap<Integer, Integer>();
    Map<Integer, Integer> domainIdToIndex = new HashMap<Integer, Integer>();
    private Button mailButton = null;
    private Button smsButton = null;
    private Button autButton = null;
    private Button evButton = null;
    private boolean inserting = true;
    public static final int tabIndex = 0;
    private static Logger logger = LoggerFactory.getLogger(MessageDetailTabItem.class);

    public MessageDetailTabItem(CTabFolder parent, int style, MessagesDetailComposite alComposite) {
        super(parent, style);
        this.messagesDetailComposite = alComposite;
    }

    public void drawComp(CTabFolder folder) throws WizardException {
        logger.debug("IN");
        Composite detailComposite = new Composite((Composite)folder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        detailComposite.setLayout((Layout)gridLayout);
        GridData gridName = SWTUtils.setGridLayoutData(768, 3);
        SWTUtils.drawLabel(detailComposite, "Name", 0, null);
        this.nameText = SWTUtils.drawText(detailComposite, 2048, gridName);
        SWTUtils.drawLabel(detailComposite, "Description", 0, null);
        this.descrText = SWTUtils.drawText(detailComposite, 2048, gridName);
        SWTUtils.drawLabel(detailComposite, "Type", 0, null);
        this.typeCombo = SWTUtils.drawCombo(detailComposite, 2048, gridName);
        SWTUtils.drawLabel(detailComposite, "Service", 0, null);
        this.serviceCombo = SWTUtils.drawCombo(detailComposite, 2048, gridName);
        SWTUtils.drawLabel(detailComposite, "Root Element", 0, null);
        this.rootElementText = SWTUtils.drawText(detailComposite, 2048, gridName);
        SWTUtils.drawLabel(detailComposite, "Start Date", 0, null);
        this.startDateButton = SWTUtils.drawDateTime(detailComposite, 2048, gridName);
        SWTUtils.drawLabel(detailComposite, "End Date", 0, null);
        this.endDateButton = SWTUtils.drawDateTime(detailComposite, 2048, gridName);
        GridData grid = new GridData(1808);
        grid.horizontalSpan = 3;
        SWTUtils.drawLabel(detailComposite, "Xml Schema", 0, null);
        this.xmlSchemaText = SWTUtils.drawStyledText(detailComposite, 2562, grid);
        SWTUtils.drawLabel(detailComposite, "Xsl", 0, null);
        this.xslText = SWTUtils.drawStyledText(detailComposite, 2562, grid);
        List<Service> serviceList = this.retrieveServices();
        int j = 0;
        this.serviceCombo.add("", j);
        ++j;
        for (Service service : serviceList) {
            this.serviceCombo.add(service.getName(), j);
            this.indexToServiceId.put(j, service.getIdService());
            this.idToService.put(service.getIdService(), service);
            this.serviceIdToIndex.put(service.getIdService(), j);
            ++j;
        }
        this.serviceCombo.select(0);
        this.serviceCombo.redraw();
        List<SbiDomain> sbiDomainList = this.retrieveSbiDomains();
        int i = 0;
        this.typeCombo.add("", i);
        ++i;
        for (SbiDomain sbiDomain : sbiDomainList) {
            this.typeCombo.add(sbiDomain.getValueCd(), i);
            this.domainIdToIndex.put(sbiDomain.getValueId(), i);
            this.indexToDomainId.put(i, sbiDomain.getValueId());
            this.idToDomain.put(sbiDomain.getValueId(), sbiDomain);
            ++i;
        }
        this.typeCombo.select(0);
        this.typeCombo.redraw();
        this.setControl((Control)detailComposite);
        logger.debug("OUT");
    }

    public void fillEmptyValues() {
        this.setInserting(true);
        this.nameText.setText("");
        this.descrText.setText("");
        this.startDateButton.setText("");
        this.startDateButton.setData(null);
        this.endDateButton.setText("");
        this.endDateButton.setData(null);
        this.rootElementText.setText("");
        this.typeCombo.select(-1);
        this.serviceCombo.select(-1);
        this.xmlSchemaText.setText("");
        this.xslText.setText("");
    }

    public void fillMessageValues(Message message) throws WizardException {
        String name = message.getName() != null ? message.getName() : "";
        this.nameText.setText(name);
        String descr = message.getDescription() != null ? message.getDescription() : "";
        this.descrText.setText(descr);
        String xmlSchema = message.getXmlSchema() != null ? message.getXmlSchema() : "";
        this.xmlSchemaText.setText(xmlSchema);
        String xsl = message.getXsl() != null ? message.getXsl() : "";
        this.xslText.setText(xsl);
        String rootElement = message.getRootElement() != null ? message.getRootElement() : "";
        this.rootElementText.setText(rootElement);
        Date startDate = message.getStartDate();
        if (startDate != null) {
            this.startDateButton.setData((Object)startDate);
            String dateString = SWTUtils.convertDateToString(startDate);
            this.startDateButton.setText(dateString);
        } else {
            this.startDateButton.setText("");
            this.startDateButton.setData(null);
        }
        Date endDate = message.getEndDate();
        if (endDate != null) {
            this.endDateButton.setData((Object)endDate);
            String dateString = SWTUtils.convertDateToString(endDate);
            this.endDateButton.setText(dateString);
        } else {
            this.endDateButton.setText("");
            this.endDateButton.setData(null);
        }
        try {
            Service service = message.getService();
            Integer id = service.getIdService();
            Integer serviceIndexToSelect = this.serviceIdToIndex.get(id);
            this.serviceCombo.select(serviceIndexToSelect.intValue());
            SbiDomain type = message.getSbiDomain();
            Integer idDomain = type.getValueId();
            Integer domainIndexToSelect = this.domainIdToIndex.get(idDomain);
            this.typeCombo.select(domainIndexToSelect.intValue());
        }
        catch (Exception e) {
            logger.error("Error in filling with details of  selected message the detail tab ", (Throwable)e);
            throw new WizardException(e, "Error in filling with details of selected message the detail tab");
        }
        logger.debug("OUT");
    }

    public void recoverSavingInformations(Message message) throws WizardException {
        Integer indexDomain;
        Integer domainId;
        logger.debug("IN");
        String name = this.nameText.getText();
        String descr = this.descrText.getText();
        String rootElement = this.rootElementText.getText();
        String xmlSchema = this.xmlSchemaText.getText();
        String xsl = this.xslText.getText();
        Date startDate = null;
        if (this.startDateButton.getData() != null) {
            startDate = (Date)this.startDateButton.getData();
        }
        Date endDate = null;
        if (this.endDateButton.getData() != null) {
            endDate = (Date)this.endDateButton.getData();
        }
        message.setName(name);
        message.setDescription(descr);
        message.setRootElement(rootElement);
        message.setXmlSchema(xmlSchema);
        message.setXsl(xsl);
        message.setStartDate(startDate);
        message.setEndDate(endDate);
        Integer indexService = this.serviceCombo.getSelectionIndex();
        Integer serviceId = this.indexToServiceId.get(indexService);
        if (serviceId != null) {
            Service service = this.idToService.get(serviceId);
            message.setService(service);
        }
        if ((domainId = this.indexToDomainId.get(indexDomain = Integer.valueOf(this.typeCombo.getSelectionIndex()))) != null) {
            SbiDomain domain = this.idToDomain.get(domainId);
            message.setSbiDomain(domain);
        }
    }

    public void disableFields() {
        this.nameText.setEnabled(false);
        this.descrText.setEnabled(false);
        this.rootElementText.setEnabled(false);
        this.typeCombo.setEnabled(false);
        this.serviceCombo.setEnabled(false);
        this.xmlSchemaText.setEnabled(false);
        this.xslText.setEnabled(false);
        this.startDateButton.setEnabled(false);
        this.endDateButton.setEnabled(false);
    }

    public void enableFields(boolean insert) {
        this.nameText.setEnabled(true);
        this.descrText.setEnabled(true);
        this.rootElementText.setEnabled(true);
        this.typeCombo.setEnabled(true);
        this.serviceCombo.setEnabled(true);
        this.xmlSchemaText.setEnabled(true);
        this.xslText.setEnabled(true);
        this.startDateButton.setEnabled(true);
        this.endDateButton.setEnabled(true);
    }

    public MessagesDetailComposite getMessagesDetailComposite() {
        return this.messagesDetailComposite;
    }

    public void setMessagesDetailComposite(MessagesDetailComposite messagesDetailComposite) {
        this.messagesDetailComposite = messagesDetailComposite;
    }

    public Text getNameText() {
        return this.nameText;
    }

    public void setNameText(Text nameText) {
        this.nameText = nameText;
    }

    public Text getDescrText() {
        return this.descrText;
    }

    public void setDescrText(Text descrText) {
        this.descrText = descrText;
    }

    public Button getMailButton() {
        return this.mailButton;
    }

    public void setMailButton(Button mailButton) {
        this.mailButton = mailButton;
    }

    public Button getSmsButton() {
        return this.smsButton;
    }

    public void setSmsButton(Button smsButton) {
        this.smsButton = smsButton;
    }

    public Button getAutButton() {
        return this.autButton;
    }

    public void setAutButton(Button autButton) {
        this.autButton = autButton;
    }

    public Button getEvButton() {
        return this.evButton;
    }

    public void setEvButton(Button evButton) {
        this.evButton = evButton;
    }

    public boolean isInserting() {
        return this.inserting;
    }

    public void setInserting(boolean inserting) {
        this.inserting = inserting;
    }

    private List<Service> retrieveServices() throws WizardException {
        List services = null;
        try {
            services = new ServiceTransactions().getServiceList();
        }
        catch (Exception e) {
            logger.error("error in retrieving services list", (Throwable)e);
            throw new WizardException(e, "error in retrieving services list");
        }
        return services;
    }

    private List<SbiDomain> retrieveSbiDomains() throws WizardException {
        List sbiDomains = null;
        try {
            sbiDomains = new SbiDomainTransactions().getDomainByDomainCd("MESSAGE_TYPE");
        }
        catch (Exception e) {
            logger.error("error in retrieving type domains list", (Throwable)e);
            throw new WizardException(e, "error in retrieving type domains list");
        }
        return sbiDomains;
    }
}

