/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.alarmwidgets;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.ebam.designers.exception.WizardException;
import org.eclipse.ebam.designers.swtutils.ColorConstants;
import org.eclipse.ebam.designers.swtutils.ImageDescriptors;
import org.eclipse.ebam.designers.wizards.pages.alarmwidgets.AlarmWizardPage;
import org.eclipse.ebam.designers.wizards.pages.alarmwidgets.AlarmsListComposite;
import org.eclipse.ebam.designers.wizards.pages.alarmwidgets.detailtabs.AlarmContactsTabItem;
import org.eclipse.ebam.designers.wizards.pages.alarmwidgets.detailtabs.AlarmDetailTabItem;
import org.eclipse.ebam.designers.wizards.pages.alarmwidgets.detailtabs.AlarmEventsTabItem;
import org.eclipse.ebam.designers.wizards.pages.alarmwidgets.detailtabs.AlarmThValueTabItem;
import org.eclipse.ebam.emf.SbiAlarmContactsTransactions;
import org.eclipse.ebam.emf.SbiAlarmTransactions;
import org.eclipse.ebam.model.entities.SbiAlarm;
import org.eclipse.ebam.model.entities.SbiAlarmContact;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmsDetailComposite
extends Composite {
    private AlarmWizardPage alarmWizardPage = null;
    private AlarmDetailTabItem detailTabItem = null;
    private AlarmThValueTabItem thValueTabItem = null;
    private AlarmContactsTabItem contactsTabItem = null;
    private AlarmEventsTabItem eventsTabItem = null;
    private Button buttonSave;
    private CTabFolder tabFolder = null;
    private Label statusLabel = null;
    public static String INSERTING = "INSERT A NEW ALARM";
    public static String MODIFYING = "MODIFY SELECTED ALARM";
    public static String EMPTY = "                                                       ";
    private static Logger logger = LoggerFactory.getLogger(AlarmsDetailComposite.class);

    public AlarmsDetailComposite(Composite parent, int style, AlarmWizardPage alarmWizardPage1) {
        super(parent, style);
        this.alarmWizardPage = alarmWizardPage1;
    }

    public void drawComp() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this.statusLabel = new Label((Composite)this, 0);
        this.statusLabel.setForeground(new Color((Device)this.getDisplay(), ColorConstants.statusLabelColor));
        this.statusLabel.setText(EMPTY);
        this.statusLabel.setLayoutData((Object)new GridData(64));
        this.buttonSave = new Button((Composite)this, 8);
        this.buttonSave.setToolTipText("Save alarm details");
        this.buttonSave.setLayoutData((Object)new GridData(128));
        Image saveImage = ImageDescriptors.getSaveIcon().createImage();
        this.buttonSave.setImage(saveImage);
        this.buttonSave.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    AlarmsDetailComposite.this.saveButtonPush();
                    AlarmsDetailComposite.this.statusLabel.setText(EMPTY);
                }
                catch (WizardException wizardException) {
                    logger.error("database connection exception");
                    MessageDialog.openError((Shell)AlarmsDetailComposite.this.getShell(), (String)"Error", (String)"Error in removing alarm");
                }
            }
        });
        this.buttonSave.setEnabled(false);
        try {
            this.tabFolder = new CTabFolder((Composite)this, 2048);
            this.tabFolder.setLayoutData((Object)new GridData(1808));
            this.tabFolder.setEnabled(false);
            this.detailTabItem = new AlarmDetailTabItem(this.tabFolder, 0, this);
            this.detailTabItem.setText("Detail");
            this.detailTabItem.drawComp(this.tabFolder);
            this.thValueTabItem = new AlarmThValueTabItem(this.tabFolder, 0, this);
            this.thValueTabItem.setText("Threshold Value");
            this.thValueTabItem.drawComp(this.tabFolder);
            this.contactsTabItem = new AlarmContactsTabItem(this.tabFolder, 0, this);
            this.contactsTabItem.setText("Contacts");
            this.contactsTabItem.drawComp(this.tabFolder);
            this.eventsTabItem = new AlarmEventsTabItem(this.tabFolder, 0, this);
            this.eventsTabItem.setText("Events");
            this.eventsTabItem.drawComp(this.tabFolder);
        }
        catch (Exception exception) {
            logger.error("could not create Alarms wizard");
            return;
        }
    }

    private void saveButtonPush() throws WizardException {
        logger.debug("IN");
        Table alarmsTable = this.getAlarmWizardPage().getListComposite().getAlarmsTable();
        int index = alarmsTable.getSelectionIndex();
        SbiAlarm sbiAlarm = null;
        if (index == -1) {
            sbiAlarm = new SbiAlarm();
        } else {
            TableItem item = alarmsTable.getItem(index);
            String label = item.getText(0);
            try {
                sbiAlarm = new SbiAlarmTransactions().getSbiAlarmByLabel(label);
            }
            catch (Exception e) {
                logger.error("error in getting sbiAlarm with label " + label, (Throwable)e);
                throw new WizardException(e, "error in getting sbiAlarm with label " + label);
            }
        }
        Set previousContact = sbiAlarm.getSbiAlarmContacts();
        HashSet<Integer> previousContactId = new HashSet<Integer>();
        if (previousContact != null) {
            for (SbiAlarmContact sbiAlarmContact : previousContact) {
                previousContactId.add(sbiAlarmContact.getAlarmContactId());
            }
        }
        AlarmDetailTabItem alarmDetailTabItem = (AlarmDetailTabItem)this.tabFolder.getItem(0);
        alarmDetailTabItem.recoverSavingInformations(sbiAlarm);
        alarmDetailTabItem.disableFields();
        AlarmThValueTabItem alarmThValueTabItem = (AlarmThValueTabItem)this.tabFolder.getItem(1);
        alarmThValueTabItem.recoverSavingInformations(sbiAlarm);
        alarmThValueTabItem.disableFields();
        AlarmContactsTabItem alarmContactsTabItem = (AlarmContactsTabItem)this.tabFolder.getItem(2);
        alarmContactsTabItem.recoverSavingInformations(sbiAlarm);
        alarmContactsTabItem.disableFields();
        AlarmEventsTabItem alarmEventsTabItem = (AlarmEventsTabItem)this.tabFolder.getItem(3);
        alarmEventsTabItem.recoverSavingInformations(sbiAlarm);
        alarmEventsTabItem.disableFields();
        SbiAlarmTransactions sbiA = new SbiAlarmTransactions();
        SbiAlarmContactsTransactions sbiACT = new SbiAlarmContactsTransactions();
        try {
            if (index == -1) {
                sbiA.mergeSbiAlarm(sbiAlarm);
                SbiAlarm again = sbiA.getSbiAlarmByLabel(sbiAlarm.getLabel());
                Set contacts = sbiAlarm.getSbiAlarmContacts();
                for (SbiAlarmContact sbiAlarmContact : contacts) {
                    sbiAlarmContact.getSbiAlarms().add(again);
                    sbiACT.mergeSbiAlarmContact(sbiAlarmContact);
                }
                TableItem tableItem = new TableItem(alarmsTable, 0);
                tableItem.setText(0, sbiAlarm.getLabel());
                tableItem.setText(1, sbiAlarm.getName());
            } else {
                sbiA.mergeSbiAlarm(sbiAlarm);
                Set actualContacts = sbiAlarm.getSbiAlarmContacts();
                HashSet<Integer> actualContactId = new HashSet<Integer>();
                for (SbiAlarmContact sbiAlarmContact : actualContacts) {
                    actualContactId.add(sbiAlarmContact.getAlarmContactId());
                }
                for (SbiAlarmContact sbiAlarmContact : previousContact) {
                    if (actualContactId.contains(sbiAlarmContact.getAlarmContactId())) continue;
                    sbiAlarmContact.getSbiAlarms().remove(sbiAlarm);
                    sbiACT.mergeSbiAlarmContact(sbiAlarmContact);
                }
                for (SbiAlarmContact sbiAlarmContact : actualContacts) {
                    if (previousContactId.contains(sbiAlarmContact.getAlarmContactId())) continue;
                    sbiAlarmContact.getSbiAlarms().add(sbiAlarm);
                    sbiACT.mergeSbiAlarmContact(sbiAlarmContact);
                }
                TableItem item = alarmsTable.getItem(index);
                item.setText(1, sbiAlarm.getName());
            }
        }
        catch (Exception e1) {
            logger.error("Error in inserting o updating alarm ", (Throwable)e1);
            throw new WizardException(e1, "Error in inserting or updating alarm");
        }
        alarmsTable.setSelection(-1);
        this.tabFolder.setEnabled(false);
        this.buttonSave.setEnabled(false);
        logger.debug("OUT");
    }

    public Integer getListSelectedAlarmId() {
        logger.debug("IN");
        AlarmsListComposite listComp = this.getAlarmWizardPage().getListComposite();
        int selectedIndex = listComp.getAlarmsTable().getSelectionIndex();
        if (selectedIndex == -1) {
            return null;
        }
        TableItem item = listComp.getAlarmsTable().getItem(selectedIndex);
        if (item == null) {
            return null;
        }
        Object o = item.getData();
        if (o == null) {
            return null;
        }
        Integer id = (Integer)o;
        logger.debug("OUT");
        return id;
    }

    public AlarmWizardPage getAlarmWizardPage() {
        return this.alarmWizardPage;
    }

    public void setAlarmWizardPage(AlarmWizardPage alarmWizardPage) {
        this.alarmWizardPage = alarmWizardPage;
    }

    public AlarmDetailTabItem getDetailTabItem() {
        return this.detailTabItem;
    }

    public void setDetailTabItem(AlarmDetailTabItem detailTabItem) {
        this.detailTabItem = detailTabItem;
    }

    public AlarmThValueTabItem getThValueTabItem() {
        return this.thValueTabItem;
    }

    public void setThValueTabItem(AlarmThValueTabItem thValueTabItem) {
        this.thValueTabItem = thValueTabItem;
    }

    public AlarmContactsTabItem getContactsTabItem() {
        return this.contactsTabItem;
    }

    public void setContactsTabItem(AlarmContactsTabItem contactsTabItem) {
        this.contactsTabItem = contactsTabItem;
    }

    public Button getButtonSave() {
        return this.buttonSave;
    }

    public void setButtonSave(Button buttonSave) {
        this.buttonSave = buttonSave;
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    public void setTabFolder(CTabFolder tabFolder) {
        this.tabFolder = tabFolder;
    }

    public Label getStatusLabel() {
        return this.statusLabel;
    }

    public void setStatusLabel(Label statusLabel) {
        this.statusLabel = statusLabel;
    }

    public AlarmEventsTabItem getEventsTabItem() {
        return this.eventsTabItem;
    }

    public void setEventsTabItem(AlarmEventsTabItem eventsTabItem) {
        this.eventsTabItem = eventsTabItem;
    }
}

