/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.resolver;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IMetadataContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.ITaglibContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.IStructuredDocumentContextResolverFactory2;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.ITextRegionContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.designtime.DTAppManagerUtil;
import org.eclipse.jst.jsf.designtime.internal.resolver.ITagElementResolver;
import org.eclipse.jst.jsf.designtime.internal.view.XMLViewDefnAdapter;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewBasedTaglibResolverFactory
implements IStructuredDocumentContextResolverFactory2,
IAdaptable {
    public IDOMContextResolver getDOMContextResolver(IStructuredDocumentContext context) {
        return null;
    }

    public IMetadataContextResolver getMetadataContextResolver(IStructuredDocumentContext context) {
        return null;
    }

    public ITaglibContextResolver getTaglibContextResolver(IStructuredDocumentContext context) {
        IWorkspaceContextResolver resolver;
        if (context.getStructuredDocument() instanceof IStructuredDocument && (resolver = INSTANCE.getWorkspaceContextResolver(context)) != null) {
            IProject project = resolver.getProject();
            IResource res = resolver.getResource();
            if (project != null && res instanceof IFile) {
                IFile file = (IFile)res;
                try {
                    return new ViewBasedTaglibResolver(context, file, project);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return null;
    }

    public ITaglibContextResolver getTaglibContextResolverFromDelegates(IStructuredDocumentContext context) {
        throw new UnsupportedOperationException();
    }

    public <T> T getResolver(IStructuredDocumentContext context, Class<T> clazz) {
        if (clazz.equals(ITagElementResolver.class) || clazz.equals(ITaglibContextResolver.class)) {
            return (T)this.getTaglibContextResolver(context);
        }
        return null;
    }

    public ITextRegionContextResolver getTextRegionResolver(IStructuredDocumentContext context) {
        return null;
    }

    public IWorkspaceContextResolver getWorkspaceContextResolver(IStructuredDocumentContext context) {
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        return null;
    }

    private static class ViewBasedTaglibResolver
    implements ITaglibContextResolver,
    ITagElementResolver {
        private final IProject _project;
        private final IFile _file;
        private final IStructuredDocumentContext _context;

        private ViewBasedTaglibResolver(IStructuredDocumentContext context, IFile file, IProject project) {
            this._context = context;
            this._file = file;
            this._project = project;
            if (DTAppManagerUtil.getXMLViewDefnAdapter(project, file) == null) {
                throw new IllegalArgumentException("View definition adapter not found");
            }
        }

        public String getTagPrefixForURI(String uri) {
            XMLViewDefnAdapter adapter = DTAppManagerUtil.getXMLViewDefnAdapter(this._file);
            if (adapter != null) {
                return adapter.getPrefix(uri, this._context.getStructuredDocument());
            }
            return null;
        }

        public String getTagURIForNodeName(Node node) {
            XMLViewDefnAdapter adapter = DTAppManagerUtil.getXMLViewDefnAdapter(this._file);
            Element element = this.getElement(node);
            if (element != null && adapter != null) {
                return adapter.getNamespace(element, this._context.getStructuredDocument());
            }
            return null;
        }

        public NodeList getTagsByNamespaceURI(String uri, String tagName) {
            return null;
        }

        public boolean hasTag(Node node) {
            return this._getTagElement(node) != null;
        }

        public boolean canResolveContext(IModelContext modelContext) {
            Object adapter = modelContext.getAdapter(IStructuredDocumentContext.class);
            if (adapter instanceof IStructuredDocumentContext) {
                return ((IStructuredDocumentContext)adapter).getStructuredDocument() instanceof IStructuredDocument;
            }
            return false;
        }

        private Element getElement(Node node) {
            Element checkNode = null;
            if (node instanceof Element) {
                checkNode = (Element)node;
            } else if (node instanceof Attr) {
                checkNode = ((Attr)node).getOwnerElement();
            }
            return checkNode;
        }

        private ITagElement _getTagElement(Node node) {
            Element element = this.getElement(node);
            XMLViewDefnAdapter adapter = DTAppManagerUtil.getXMLViewDefnAdapter(this._project, this._file);
            if (element != null && adapter != null) {
                return adapter.mapToTagElement(element, this._context.getStructuredDocument());
            }
            return null;
        }

        public ITagElement getTagElement(Node node) {
            return this._getTagElement(node);
        }
    }
}

