/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IJointDataSetDesign;
import org.eclipse.birt.data.engine.api.IOdaDataSetDesign;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.expression.NamedExpression;
import org.eclipse.birt.data.engine.impl.ConfigFileParser;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.DataSetDesignHelper;
import org.eclipse.birt.data.engine.impl.DummyPreparedQuery;
import org.eclipse.birt.data.engine.impl.FilterPrepareUtil;
import org.eclipse.birt.data.engine.impl.IIncreCacheDataSetDesign;
import org.eclipse.birt.data.engine.impl.IQueryContextVisitor;
import org.eclipse.birt.data.engine.impl.IncreCacheDataSetAdapter;
import org.eclipse.birt.data.engine.impl.JointDataSetAdapter;
import org.eclipse.birt.data.engine.impl.OdaDataSetAdapter;
import org.eclipse.birt.data.engine.impl.PLSUtil;
import org.eclipse.birt.data.engine.impl.PreparedDummyQuery;
import org.eclipse.birt.data.engine.impl.PreparedIVDataExtractionQuery;
import org.eclipse.birt.data.engine.impl.PreparedIVDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedIncreCacheDSQuery;
import org.eclipse.birt.data.engine.impl.PreparedJointDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedOdaDSQuery;
import org.eclipse.birt.data.engine.impl.PreparedScriptDSQuery;
import org.eclipse.birt.data.engine.impl.QueryCompUtil;
import org.eclipse.birt.data.engine.impl.QueryContextVisitorUtil;
import org.eclipse.birt.data.engine.impl.QueryDefinitionUtil;
import org.eclipse.birt.data.engine.impl.QueryPrepareUtil;
import org.eclipse.birt.data.engine.impl.ScriptDataSetAdapter;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.RDLoad;
import org.eclipse.birt.data.engine.impl.document.RDUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;

public class PreparedQueryUtil {
    private static final int BASED_ON_DATASET = 2;
    private static final int BASED_ON_PRESENTATION = 3;

    public static IPreparedQuery newInstance(DataEngineImpl dataEngine, IQueryDefinition queryDefn, Map appContext) throws DataException {
        assert (dataEngine != null);
        assert (queryDefn != null);
        if (queryDefn.getDistinctValue()) {
            PreparedQueryUtil.addAllBindingAsSortKey(queryDefn);
        }
        PreparedQueryUtil.validateQuery(dataEngine, queryDefn);
        FilterPrepareUtil.prepareFilters(queryDefn, dataEngine.getContext().getScriptContext());
        IQueryContextVisitor contextVisitor = QueryContextVisitorUtil.createQueryContextVisitor(queryDefn, appContext);
        if (queryDefn.getSourceQuery() != null) {
            return new PreparedIVDataExtractionQuery(dataEngine, queryDefn, appContext, contextVisitor);
        }
        IPreparedQuery preparedQuery = QueryPrepareUtil.prepareQuery(dataEngine, queryDefn, dataEngine.getDataSetDesign(queryDefn.getDataSetName()), appContext, contextVisitor);
        if (preparedQuery != null) {
            return preparedQuery;
        }
        if (queryDefn.getQueryResultsID() != null) {
            if (dataEngine.getContext().getMode() == 1 || dataEngine.getContext().getMode() == 3) {
                return new DummyPreparedQuery(queryDefn, dataEngine.getSession());
            }
            if (dataEngine.getContext().getMode() == 2) {
                return new DummyPreparedQuery(queryDefn, dataEngine.getSession(), dataEngine.getContext(), queryDefn.getQueryExecutionHints() != null ? queryDefn.getQueryExecutionHints().getTargetGroupInstances() : null);
            }
            return PreparedQueryUtil.newIVInstance(dataEngine, queryDefn, appContext);
        }
        IBaseDataSetDesign dset = PreparedQueryUtil.cloneDataSetDesign(dataEngine.getDataSetDesign(queryDefn.getDataSetName()), appContext);
        if (dset == null && queryDefn.getQueryResultsID() == null) {
            return new PreparedDummyQuery(queryDefn, dataEngine.getSession());
        }
        FilterPrepareUtil.prepareFilters(dset.getFilters(), dataEngine.getContext().getScriptContext());
        QueryContextVisitorUtil.populateDataSet(contextVisitor, dset);
        if (dset instanceof IScriptDataSetDesign) {
            preparedQuery = new PreparedScriptDSQuery(dataEngine, queryDefn, dset, appContext, contextVisitor);
        } else if (dset instanceof IOdaDataSetDesign) {
            preparedQuery = dset instanceof IIncreCacheDataSetDesign ? new PreparedIncreCacheDSQuery(dataEngine, queryDefn, dset, appContext) : new PreparedOdaDSQuery(dataEngine, queryDefn, dset, appContext, contextVisitor);
        } else if (dset instanceof IJointDataSetDesign) {
            preparedQuery = new PreparedJointDataSourceQuery(dataEngine, queryDefn, dset, appContext, contextVisitor);
        } else {
            preparedQuery = DataSetDesignHelper.createPreparedQueryInstance(dset, dataEngine, queryDefn, appContext);
            if (preparedQuery == null) {
                throw new DataException("data.engine.UnsupportedDataSetType", dset.getName());
            }
        }
        return preparedQuery;
    }

    private static void addAllBindingAsSortKey(IQueryDefinition queryDefn) throws DataException {
        if (!(queryDefn instanceof BaseQueryDefinition)) {
            return;
        }
        HashSet<String> sortedBinding = new HashSet<String>();
        List sorts = queryDefn.getSorts();
        if (sorts != null) {
            for (ISortDefinition sd : sorts) {
                List bindingNames = ExpressionCompilerUtil.extractColumnExpression((IBaseExpression)sd.getExpression(), "row");
                if (bindingNames != null && bindingNames.size() > 0) {
                    for (String bindingName : bindingNames) {
                        sortedBinding.add(bindingName);
                    }
                    continue;
                }
                if (sd.getColumn() == null) continue;
                sortedBinding.add(sd.getColumn());
            }
        }
        Iterator bindings = queryDefn.getBindings().values().iterator();
        BaseQueryDefinition queryDefinition = (BaseQueryDefinition)((Object)queryDefn);
        while (bindings.hasNext()) {
            IBinding binding = (IBinding)bindings.next();
            if (sortedBinding.contains(binding.getBindingName())) continue;
            SortDefinition sd = new SortDefinition();
            sd.setExpression(ExpressionUtil.createJSRowExpression((String)binding.getBindingName()));
            queryDefinition.addSort(sd);
        }
    }

    private static void validateQuery(DataEngineImpl dataEngine, IQueryDefinition queryDefn) throws DataException {
        String dataSetName = queryDefn.getDataSetName();
        IBaseDataSetDesign dataSet = dataEngine.getDataSetDesign(dataSetName);
        if (dataSet != null) {
            PreparedQueryUtil.validateComputedColumns(dataSet);
        }
        PreparedQueryUtil.validateSorts(queryDefn);
    }

    private static void validateSummaryQuery(IQueryDefinition queryDefn) throws DataException {
        if (queryDefn.isSummaryQuery()) {
            String lastGroupName = null;
            if (queryDefn.getGroups().size() > 0) {
                IGroupDefinition group = (IGroupDefinition)queryDefn.getGroups().get(queryDefn.getGroups().size() - 1);
                lastGroupName = group.getName();
            }
            Map bindings = queryDefn.getBindings();
            for (IBinding binding : bindings.values()) {
                if (binding.getAggrFunction() == null || binding.getAggregatOns().size() == 0 && lastGroupName == null || binding.getAggregatOns().size() == 1 && binding.getAggregatOns().get(0).toString().equals(lastGroupName)) continue;
                throw new DataException("data.engine.InvalidAggrLevelKeyInSummaryQuery", binding.getBindingName());
            }
        }
    }

    private static void validateSorts(IQueryDefinition queryDefn) throws DataException {
        List sorts = queryDefn.getSorts();
        if (sorts != null) {
            for (ISortDefinition sd : sorts) {
                List bindingNames = ExpressionCompilerUtil.extractColumnExpression((IBaseExpression)sd.getExpression(), "row");
                if (bindingNames == null) continue;
                for (String bindingName : bindingNames) {
                    IBinding binding = (IBinding)queryDefn.getBindings().get(bindingName);
                    if (binding == null || binding.getAggrFunction() == null) continue;
                    throw new DataException("data.engine.SortOnAggregation", bindingName);
                }
            }
        }
    }

    private static void validateComputedColumns(IBaseDataSetDesign bdsd) throws DataException {
        List ccs = bdsd.getComputedColumns();
        if (ccs != null) {
            HashSet<NamedExpression> namedExpressions = new HashSet<NamedExpression>();
            for (IComputedColumn cc : ccs) {
                String name = cc.getName();
                if (name == null || name.equals("")) {
                    throw new DataException("data.engine.EmptyCustomFieldName");
                }
                IBaseExpression expr = cc.getExpression();
                namedExpressions.add(new NamedExpression(name, expr));
            }
            String nameInvolvedInCycle = ExpressionCompilerUtil.getFirstFoundNameInCycle(namedExpressions, "row");
            if (nameInvolvedInCycle != null) {
                throw new DataException("data.engine.ComputedColumnCycle", nameInvolvedInCycle);
            }
        }
    }

    private static IBaseDataSetDesign cloneDataSetDesign(IBaseDataSetDesign dataSetDesign, Map appContext) throws DataException {
        if (dataSetDesign instanceof IScriptDataSetDesign) {
            return new ScriptDataSetAdapter(dataSetDesign);
        }
        if (dataSetDesign instanceof IOdaDataSetDesign) {
            return PreparedQueryUtil.adaptOdaDataSetDesign(dataSetDesign, appContext);
        }
        if (dataSetDesign instanceof IJointDataSetDesign) {
            return new JointDataSetAdapter(dataSetDesign);
        }
        IBaseDataSetDesign design = DataSetDesignHelper.createAdapter(dataSetDesign);
        return design;
    }

    private static IBaseDataSetDesign adaptOdaDataSetDesign(IBaseDataSetDesign dataSetDesign, Map appContext) throws DataException {
        OdaDataSetAdapter adaptedDesign = null;
        URL configFileUrl = IncreCacheDataSetAdapter.getConfigFileURL(appContext);
        if (configFileUrl != null) {
            try {
                InputStream is = configFileUrl.openStream();
                ConfigFileParser parser = new ConfigFileParser(is);
                String id = dataSetDesign.getName();
                if (parser.containDataSet(id)) {
                    final String mode = parser.getModeByID(id);
                    if ("incremental".equalsIgnoreCase(mode)) {
                        String queryTemplate = parser.getQueryTextByID(id);
                        String timestampColumn = parser.getTimeStampColumnByID(id);
                        String formatPattern = parser.getTSFormatByID(id);
                        IncreCacheDataSetAdapter pscDataSet = new IncreCacheDataSetAdapter(dataSetDesign);
                        pscDataSet.setCacheMode(1);
                        pscDataSet.setConfigFileUrl(configFileUrl);
                        pscDataSet.setQueryTemplate(queryTemplate);
                        pscDataSet.setTimestampColumn(timestampColumn);
                        pscDataSet.setFormatPattern(formatPattern);
                        adaptedDesign = pscDataSet;
                    } else {
                        String message = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                return MessageFormat.format("data.cache.UnsupportedIncrementalCacheMode", mode);
                            }
                        });
                        throw new UnsupportedOperationException(message);
                    }
                }
                is.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (adaptedDesign == null) {
            adaptedDesign = new OdaDataSetAdapter(dataSetDesign);
        }
        return adaptedDesign;
    }

    private static IPreparedQuery newIVInstance(DataEngineImpl dataEngine, IQueryDefinition queryDefn, Map appContext) throws DataException {
        switch (PreparedQueryUtil.runQueryOnRS(dataEngine, queryDefn)) {
            case 2: {
                return new PreparedIVDataSourceQuery(dataEngine, queryDefn, QueryContextVisitorUtil.createQueryContextVisitor(queryDefn, appContext));
            }
        }
        return new DummyPreparedQuery(queryDefn, dataEngine.getSession(), dataEngine.getContext(), PLSUtil.isPLSEnabled(queryDefn) ? queryDefn.getQueryExecutionHints().getTargetGroupInstances() : null);
    }

    private static int runQueryOnRS(DataEngineImpl dataEngine, IQueryDefinition queryDefn) throws DataException {
        String queryResultID = queryDefn.getQueryResultsID();
        String rootQueryResultID = QueryResultIDUtil.get1PartID(queryResultID);
        String parentQueryResultID = null;
        if (rootQueryResultID != null) {
            parentQueryResultID = QueryResultIDUtil.get2PartID(queryResultID);
        } else {
            rootQueryResultID = queryResultID;
        }
        QueryResultInfo queryResultInfo = new QueryResultInfo(rootQueryResultID, parentQueryResultID, null, null, -1);
        RDLoad rdLoad = RDUtil.newLoad(dataEngine.getSession().getTempDir(), dataEngine.getContext(), queryResultInfo);
        IBaseQueryDefinition previousQueryDefn = rdLoad.loadQueryDefn(0, 1);
        if (QueryCompUtil.isIVQueryDefnEqual(dataEngine.getContext().getMode(), previousQueryDefn, queryDefn)) {
            return 3;
        }
        if (queryDefn.isSummaryQuery()) {
            IResultClass rsMeta = rdLoad.loadExprDataResultSet(true).getResultClass();
            PreparedQueryUtil.populateSummaryBinding(queryDefn, rsMeta);
        }
        return 2;
    }

    private static void populateSummaryBinding(IQueryDefinition queryDefn, IResultClass rsMeta) throws DataException {
        HashSet<String> nameSet = new HashSet<String>();
        int i = 1;
        while (i < rsMeta.getFieldCount()) {
            nameSet.add(rsMeta.getFieldName(i));
            ++i;
        }
        for (IBinding binding : queryDefn.getBindings().values()) {
            if (!nameSet.contains(binding.getBindingName())) continue;
            binding.setAggrFunction(null);
            binding.getAggregatOns().clear();
            binding.getArguments().clear();
            binding.setExpression(new ScriptExpression(ExpressionUtil.createDataSetRowExpression((String)binding.getBindingName())));
        }
    }

    static void mappingParentColumnBinding(IBaseQueryDefinition baseQueryDefn) throws DataException {
        IBaseQueryDefinition queryDef = baseQueryDefn;
        while (queryDef instanceof ISubqueryDefinition) {
            queryDef = queryDef.getParentQuery();
            Map parentBindings = queryDef.getBindings();
            PreparedQueryUtil.addParentBindings(baseQueryDefn, parentBindings);
        }
    }

    static void addParentBindings(IBaseQueryDefinition baseQueryDefn, Map parentBindings) throws DataException {
        Map<String, Boolean> aggrInfo = QueryDefinitionUtil.parseAggregations(parentBindings);
        for (String name : parentBindings.keySet()) {
            if (aggrInfo.get(name).booleanValue()) continue;
            IBinding b = (IBinding)parentBindings.get(name);
            if (baseQueryDefn.getBindings().get(name) != null) continue;
            Binding binding = new Binding(name);
            binding.setDataType(b.getDataType());
            binding.setExpression(PreparedQueryUtil.copyScriptExpr(b.getExpression()));
            baseQueryDefn.addBinding(binding);
        }
    }

    private static ScriptExpression copyScriptExpr(IBaseExpression expr) {
        if (expr == null) {
            return null;
        }
        ScriptExpression se = new ScriptExpression(((IScriptExpression)expr).getText(), ((IScriptExpression)expr).getDataType());
        return se;
    }
}

