/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.birt.report.viewer.utilities.WebViewer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ViewerPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.birt.report.viewer";
    public static final String WEBAPP_CONTEXT = "viewer";
    public static final int DEFAULT_MAX_ROWS = 500;
    public static final int DEFAULT_MAX_CUBEROWLEVELS = 50;
    public static final int DEFAULT_MAX_CUBECOLUMNLEVELS = 50;
    public static final int DEFAULT_MAX_IN_MEMORY_CUBE_SIZE = 10;
    public static final String BIRT_VIEWER_WORKING_PATH = "birt.viewer.working.path";
    public static final String BIRT_VIEWER_ROOT_PATH = "birt.viewer.root.path";
    public static final String BIRT_IS_DESIGNER = "birt.designer";
    private static ViewerPlugin plugin;
    private ResourceBundle resourceBundle;
    private BundleContext bundleContext;

    public ViewerPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle(ViewerPlugin.class.getName());
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        String rootPath;
        super.start(context);
        this.bundleContext = context;
        plugin.getPluginPreferences().setDefault("master_page_content", true);
        plugin.getPluginPreferences().setDefault("preview_maxrow", 500);
        plugin.getPluginPreferences().setDefault("preview_maxrowlevelmember", 50);
        plugin.getPluginPreferences().setDefault("preview_maxcolumnlevelmember", 50);
        plugin.getPluginPreferences().setDefault("preview_maxinmemorycubesize", 10);
        plugin.getPluginPreferences().setDefault("user_locale", ULocale.getDefault().getDisplayName());
        plugin.getPluginPreferences().setDefault("user_time_zone", TimeZone.getDefault().getID());
        plugin.getPluginPreferences().setDefault("bidi_orientation", "auto");
        if (plugin.getStateLocation() != null) {
            System.setProperty(BIRT_VIEWER_WORKING_PATH, plugin.getStateLocation().toOSString());
        }
        if ((rootPath = this.getFilePath("/birt")) != null) {
            System.setProperty(BIRT_VIEWER_ROOT_PATH, rootPath);
        }
        System.setProperty(BIRT_IS_DESIGNER, "true");
        WebViewer.getCurrentWebApp();
    }

    private String getFilePath(String path) {
        try {
            Bundle bundle = this.getBundle();
            URL url = new URL(bundle.getEntry("/"), path);
            return FileLocator.toFileURL((URL)url).getFile();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void stop(BundleContext context) throws Exception {
        WebViewer.stopAll();
        super.stop(context);
    }

    public static ViewerPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = ViewerPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getFormattedResourceString(String key, Object[] arguments) {
        return MessageFormat.format(ViewerPlugin.getResourceString(key), arguments);
    }

    public static synchronized void logError(String message, Throwable ex) {
        if (message == null) {
            message = "";
        }
        Status errorStatus = new Status(4, PLUGIN_ID, 0, message, ex);
        ViewerPlugin.getDefault().getLog().log((IStatus)errorStatus);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public Bundle[] getBundles() {
        return this.bundleContext == null ? new Bundle[]{} : this.bundleContext.getBundles();
    }
}

