/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.Path;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.util.ProductPreferences;
import org.eclipse.help.internal.webapp.data.CssUtil;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.FilterHTMLHeadAndBodyOutputStream;
import org.eclipse.help.internal.webapp.servlet.FilterUtils;
import org.eclipse.help.webapp.IFilter;

public class InjectionFilter
implements IFilter {
    private static final String disabledBook3 = "\n<script type=\"text/javascript\" src=\"";
    private static final String disabledBook4 = "livehelp.js\"> </script>";
    private final String TOPIC_CSS = "topic_css";
    private final String NAV_CSS = "nav_css";
    private final String NARROW_CSS = "narrow_css";
    private final String DISABLED_CSS = "disabled_css";

    public OutputStream filter(HttpServletRequest req, OutputStream out) {
        boolean enabled;
        boolean isUnfiltered = ProductPreferences.useEnablementFilters();
        boolean addNarrow = false;
        boolean addDisabled = false;
        boolean needsLiveHelp = false;
        String uri = req.getRequestURI();
        boolean isNav = "/nav".equals(req.getServletPath());
        if (uri == null || !uri.endsWith("html") && !uri.endsWith("htm") && !isNav) {
            return out;
        }
        if (UrlUtil.isBot(req)) {
            return out;
        }
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            return out;
        }
        ArrayList cssIncludes = new ArrayList();
        if (isNav) {
            CssUtil.addCssFiles("nav_css", cssIncludes);
        } else {
            CssUtil.addCssFiles("topic_css", cssIncludes);
        }
        boolean bl = enabled = isUnfiltered || isNav || HelpBasePlugin.getActivitySupport().isRoleEnabled(pathInfo);
        if ("/ntopic".equals(req.getServletPath())) {
            addNarrow = true;
            CssUtil.addCssFiles("narrow_css", cssIncludes);
        }
        if (!enabled) {
            addDisabled = true;
            CssUtil.addCssFiles("disabled_css", cssIncludes);
        }
        boolean bl2 = needsLiveHelp = !enabled && HelpBasePlugin.getActivitySupport().getDocumentMessageUsesLiveHelp(addNarrow);
        if (cssIncludes.size() == 0 && !addDisabled) {
            return out;
        }
        Path path = new Path(pathInfo);
        int upLevels = path.segmentCount() - 1;
        String relativePath = FilterUtils.getRelativePathPrefix(req);
        StringBuffer script = new StringBuffer();
        StringBuffer disabledContent = new StringBuffer();
        script.append(CssUtil.createCssIncludes(cssIncludes, FilterUtils.getRelativePathPrefix(req)));
        if (addDisabled) {
            if (needsLiveHelp) {
                script.append(disabledBook3);
                script.append(relativePath);
                script.append("content/org.eclipse.help/");
                script.append(disabledBook4);
            }
            this.appendDisabled(disabledContent, upLevels, addNarrow, relativePath);
        }
        try {
            return new FilterHTMLHeadAndBodyOutputStream(out, script.toString().getBytes("ASCII"), addDisabled ? disabledContent.toString() : null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return out;
        }
    }

    private void appendDisabled(StringBuffer buff, int nsteps, boolean narrow, String relativePath) {
        String message = HelpBasePlugin.getActivitySupport().getDocumentMessage(narrow);
        if (message == null) {
            return;
        }
        buff.append("<div id=\"help-disabledTopic\">");
        buff.append("<img src=\"");
        buff.append(relativePath);
        buff.append("content/org.eclipse.help.webapp/");
        buff.append("advanced/images/e_show_all.gif\" border=\"0\" align=\"bottom\">&nbsp;");
        buff.append(message);
        buff.append("<br><hr></div>");
    }
}

