/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.commands;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.epp.internal.mpc.core.service.Category;
import org.eclipse.epp.internal.mpc.core.service.Market;
import org.eclipse.epp.internal.mpc.ui.CatalogRegistry;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalog;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCategory;
import org.eclipse.epp.internal.mpc.ui.commands.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.ComboTagFilter;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceCatalogConfiguration;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceFilter;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceWizard;
import org.eclipse.epp.internal.mpc.ui.wizards.Operation;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.equinox.internal.p2.discovery.DiscoveryCore;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.Tag;
import org.eclipse.equinox.internal.p2.ui.discovery.util.WorkbenchUtil;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketplaceWizardCommand
extends AbstractHandler
implements IHandler {
    private List<CatalogDescriptor> catalogDescriptors;
    private CatalogDescriptor selectedCatalogDescriptor;
    private String wizardState;
    private Map<String, Operation> operationByNodeId;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final MarketplaceCatalog catalog = new MarketplaceCatalog();
        catalog.setEnvironment(DiscoveryCore.createEnvironment());
        catalog.setVerifyUpdateSiteAvailability(false);
        MarketplaceCatalogConfiguration configuration = new MarketplaceCatalogConfiguration();
        configuration.setVerifyUpdateSiteAvailability(false);
        if (this.catalogDescriptors == null || this.catalogDescriptors.isEmpty()) {
            configuration.getCatalogDescriptors().addAll(CatalogRegistry.getInstance().getCatalogDescriptors());
        } else {
            configuration.getCatalogDescriptors().addAll(this.catalogDescriptors);
        }
        if (this.selectedCatalogDescriptor != null) {
            configuration.setCatalogDescriptor(this.selectedCatalogDescriptor);
        }
        configuration.getFilters().clear();
        ComboTagFilter marketFilter = new ComboTagFilter(){

            public void catalogUpdated(boolean wasCancelled) {
                ArrayList<Tag> choices = new ArrayList<Tag>();
                for (CatalogCategory category : catalog.getCategories()) {
                    if (!(category instanceof MarketplaceCategory)) continue;
                    MarketplaceCategory marketplaceCategory = (MarketplaceCategory)category;
                    for (Market market : marketplaceCategory.getMarkets()) {
                        Tag marketTag = new Tag(Market.class, market.getId(), market.getName());
                        marketTag.setData((Object)market);
                        choices.add(marketTag);
                    }
                }
                this.setChoices(choices);
            }
        };
        marketFilter.setSelectAllOnNoSelection(true);
        marketFilter.setNoSelectionLabel(Messages.MarketplaceWizardCommand_allMarkets);
        marketFilter.setTagClassification(Category.class);
        marketFilter.setChoices(new ArrayList<Tag>());
        ComboTagFilter marketCategoryTagFilter = new ComboTagFilter(){

            public void catalogUpdated(boolean wasCancelled) {
                HashSet<Tag> newChoices = new HashSet<Tag>();
                ArrayList<Tag> choices = new ArrayList<Tag>();
                for (CatalogCategory category : catalog.getCategories()) {
                    if (!(category instanceof MarketplaceCategory)) continue;
                    MarketplaceCategory marketplaceCategory = (MarketplaceCategory)category;
                    for (Market market : marketplaceCategory.getMarkets()) {
                        for (Category marketCategory : market.getCategory()) {
                            Tag categoryTag = new Tag(Category.class, marketCategory.getId(), marketCategory.getName());
                            categoryTag.setData((Object)marketCategory);
                            if (!newChoices.add(categoryTag)) continue;
                            choices.add(categoryTag);
                        }
                    }
                }
                this.setChoices(choices);
            }
        };
        marketCategoryTagFilter.setSelectAllOnNoSelection(true);
        marketCategoryTagFilter.setNoSelectionLabel(Messages.MarketplaceWizardCommand_allCategories);
        marketCategoryTagFilter.setTagClassification(Category.class);
        marketCategoryTagFilter.setChoices(new ArrayList<Tag>());
        configuration.getFilters().add(marketFilter);
        configuration.getFilters().add(marketCategoryTagFilter);
        configuration.setInitialState(this.wizardState);
        if (this.operationByNodeId != null && !this.operationByNodeId.isEmpty()) {
            configuration.setInitialOperationByNodeId(this.operationByNodeId);
        }
        for (CatalogFilter filter : configuration.getFilters()) {
            ((MarketplaceFilter)filter).setCatalog(catalog);
        }
        MarketplaceWizard wizard = new MarketplaceWizard(catalog, configuration);
        wizard.setWindowTitle(Messages.MarketplaceWizardCommand_eclipseMarketplace);
        WizardDialog dialog = new WizardDialog(WorkbenchUtil.getShell(), (IWizard)wizard);
        dialog.open();
        return null;
    }

    public void setCatalogDescriptors(List<CatalogDescriptor> catalogDescriptors) {
        this.catalogDescriptors = catalogDescriptors;
    }

    public void setSelectedCatalogDescriptor(CatalogDescriptor selectedCatalogDescriptor) {
        this.selectedCatalogDescriptor = selectedCatalogDescriptor;
    }

    public void setWizardState(String wizardState) {
        this.wizardState = wizardState;
    }

    public void setOperationByNodeId(Map<String, Operation> operationByNodeId) {
        this.operationByNodeId = operationByNodeId;
    }
}

