/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.parts;

import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.parts.CheckboxTablePart;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class WizardCheckboxTablePart
extends CheckboxTablePart {
    private int selectAllIndex = -1;
    private int deselectAllIndex = -1;
    private String tableName;
    private int counter;
    private Label counterLabel;

    public WizardCheckboxTablePart(String tableName, String[] buttonLabels) {
        super(buttonLabels);
        this.tableName = tableName;
    }

    public WizardCheckboxTablePart(String mainLabel) {
        this(mainLabel, new String[]{PDEUIMessages.WizardCheckboxTablePart_selectAll, PDEUIMessages.WizardCheckboxTablePart_deselectAll});
        this.setSelectAllIndex(0);
        this.setDeselectAllIndex(1);
    }

    public void setSelectAllIndex(int index) {
        this.selectAllIndex = index;
    }

    public void setDeselectAllIndex(int index) {
        this.deselectAllIndex = index;
    }

    protected void buttonSelected(Button button, int index) {
        if (index == this.selectAllIndex) {
            this.handleSelectAll(true);
        }
        if (index == this.deselectAllIndex) {
            this.handleSelectAll(false);
        }
    }

    public Object[] getSelection() {
        CheckboxTableViewer viewer = this.getTableViewer();
        return viewer.getCheckedElements();
    }

    public void setSelection(Object[] selected) {
        CheckboxTableViewer viewer = this.getTableViewer();
        viewer.setCheckedElements(selected);
        this.updateCounter(viewer.getCheckedElements().length);
    }

    public void createControl(Composite parent) {
        this.createControl(parent, 2);
    }

    public void createControl(Composite parent, int span) {
        this.createControl(parent, 0, span, null);
        this.counterLabel = new Label(parent, 0);
        GridData gd = new GridData(258);
        gd.horizontalSpan = span;
        this.counterLabel.setLayoutData((Object)gd);
        this.updateCounter(0);
    }

    protected Button createButton(Composite parent, String label, int index, FormToolkit toolkit) {
        Button button = super.createButton(parent, label, index, toolkit);
        SWTUtil.setButtonDimensionHint(button);
        return button;
    }

    protected StructuredViewer createStructuredViewer(Composite parent, int style, FormToolkit toolkit) {
        StructuredViewer viewer = super.createStructuredViewer(parent, style, toolkit);
        viewer.setComparator(ListUtil.NAME_COMPARATOR);
        return viewer;
    }

    protected void createMainLabel(Composite parent, int span, FormToolkit toolkit) {
        if (this.tableName == null) {
            return;
        }
        Label label = new Label(parent, 0);
        label.setText(this.tableName);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        label.setLayoutData((Object)gd);
    }

    protected void updateCounter(int amount) {
        this.counter = amount;
        this.updateCounterLabel();
    }

    protected void updateCounterLabel() {
        String number = "" + this.getSelectionCount();
        String totalNumber = "" + this.getTotalCount();
        String message = NLS.bind((String)PDEUIMessages.WizardCheckboxTablePart_counter, (Object[])new String[]{number, totalNumber});
        this.counterLabel.setText(message);
    }

    public int getSelectionCount() {
        return this.counter;
    }

    public void selectAll(boolean select) {
        this.handleSelectAll(select);
    }

    private int getTotalCount() {
        CheckboxTableViewer viewer = this.getTableViewer();
        return viewer.getTable().getItemCount();
    }

    protected void handleSelectAll(boolean select) {
        CheckboxTableViewer viewer = this.getTableViewer();
        viewer.setAllChecked(select);
        int selected = !select ? 0 : this.getTotalCount();
        this.updateCounter(selected);
    }

    protected void elementChecked(Object element, boolean checked) {
        int count = this.getSelectionCount();
        this.updateCounter(checked ? count + 1 : count - 1);
    }

    public Label getCounterLabel() {
        return this.counterLabel;
    }
}

