/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.tasklist;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.mylyn.internal.bugzilla.ui.tasklist.Messages;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositoryQueryPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BugzillaCustomQueryWizardPage
extends AbstractRepositoryQueryPage {
    private static final String LABEL_CUSTOM_TITLE = Messages.BugzillaCustomQueryWizardPage_Query_Title;
    private static final String LABEL_CUSTOM_QUERY = Messages.BugzillaCustomQueryWizardPage_Query_URL;
    private static final String TITLE = Messages.BugzillaCustomQueryWizardPage_Create_query_from_URL;
    private static final String DESCRIPTION = Messages.BugzillaCustomQueryWizardPage_Enter_the_title_and_URL_for_the_query;
    private Text queryText;
    private final IRepositoryQuery query;
    private Text queryTitle;

    public BugzillaCustomQueryWizardPage(TaskRepository repository, IRepositoryQuery query) {
        super(TITLE, repository, query);
        this.query = query;
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        this.setImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
    }

    public BugzillaCustomQueryWizardPage(TaskRepository repository) {
        this(repository, null);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)composite);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BugzillaCustomQueryWizardPage.this.setPageComplete(BugzillaCustomQueryWizardPage.this.isPageComplete());
            }
        };
        Label queryTitleLabel = new Label(composite, 0);
        queryTitleLabel.setText(LABEL_CUSTOM_TITLE);
        this.queryTitle = new Text(composite, 2048);
        this.queryTitle.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.queryTitle.addModifyListener(modifyListener);
        this.queryTitle.setFocus();
        Label queryUrlLabel = new Label(composite, 0);
        queryUrlLabel.setText(LABEL_CUSTOM_QUERY);
        this.queryText = new Text(composite, 2048);
        GridData gd_queryText = new GridData(4, 0x1000000, true, false);
        gd_queryText.widthHint = 300;
        this.queryText.setLayoutData((Object)gd_queryText);
        this.queryText.addModifyListener(modifyListener);
        if (this.query != null) {
            this.queryTitle.setText(this.query.getSummary());
            this.queryText.setText(this.query.getUrl());
        }
        Dialog.applyDialogFont((Control)composite);
    }

    public String getQueryTitle() {
        return this.queryTitle.getText();
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public boolean isPageComplete() {
        if (super.isPageComplete()) {
            if (this.queryText.getText().length() > 0) {
                return true;
            }
            this.setErrorMessage(Messages.BugzillaCustomQueryWizardPage_Please_specify_Query_URL);
        }
        return false;
    }

    public void applyTo(IRepositoryQuery query) {
        query.setSummary(this.getQueryTitle());
        query.setUrl(this.queryText.getText());
        query.setAttribute("bugzilla.query.custom", Boolean.TRUE.toString());
    }
}

