/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal;

import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentproperties.JSPFContentPropertiesManager;
import org.eclipse.jst.jsp.core.internal.contenttype.DeploymentDescriptorPropertyCache;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslatorPersister;
import org.eclipse.jst.jsp.core.internal.java.search.JSPIndexManager;
import org.eclipse.jst.jsp.core.internal.taglib.TaglibHelperManager;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.osgi.framework.BundleContext;

public class JSPCorePlugin
extends Plugin {
    private static JSPCorePlugin plugin;
    private ISaveParticipant fSaveParticipant;

    public JSPCorePlugin() {
        plugin = this;
        this.fSaveParticipant = new SaveParticipant();
    }

    public static JSPCorePlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        TaglibIndex.startup();
        TaglibController.startup();
        JavaCore.addElementChangedListener((IElementChangedListener)TaglibHelperManager.getInstance());
        if (JSPTranslatorPersister.ACTIVATED) {
            try {
                final ISavedState savedState = ResourcesPlugin.getWorkspace().addSaveParticipant(plugin.getBundle().getSymbolicName(), this.fSaveParticipant);
                if (savedState != null) {
                    Job persister = new Job(JSPCoreMessages.Initializing){

                        /*
                         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                Thread.currentThread().setPriority(1);
                            }
                            catch (Throwable throwable) {
                                Object var2_3 = null;
                                savedState.processResourceChangeEvents((IResourceChangeListener)JSPTranslatorPersister.getDefault());
                                throw throwable;
                            }
                            {
                                Object var2_4 = null;
                            }
                            savedState.processResourceChangeEvents((IResourceChangeListener)JSPTranslatorPersister.getDefault());
                            return Status.OK_STATUS;
                        }
                    };
                    persister.setUser(false);
                    persister.schedule(2000L);
                }
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)JSPTranslatorPersister.getDefault());
            }
            catch (CoreException e) {
                Logger.logException("Could not load previous save state", e);
            }
        }
        JSPIndexManager.getInstance().initialize();
        JSPFContentPropertiesManager.startup();
        DeploymentDescriptorPropertyCache.start();
    }

    public void stop(BundleContext context) throws Exception {
        DeploymentDescriptorPropertyCache.stop();
        JSPFContentPropertiesManager.shutdown();
        ResourcesPlugin.getWorkspace().removeSaveParticipant(plugin.getBundle().getSymbolicName());
        if (JSPTranslatorPersister.ACTIVATED) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)JSPTranslatorPersister.getDefault());
        }
        JSPIndexManager.getInstance().shutdown();
        JavaCore.removeElementChangedListener((IElementChangedListener)TaglibHelperManager.getInstance());
        TaglibController.shutdown();
        TaglibIndex.shutdown();
        super.stop(context);
    }

    private static class SaveParticipant
    implements ISaveParticipant {
        protected SaveParticipant() {
        }

        public void doneSaving(ISaveContext context) {
        }

        public void prepareToSave(ISaveContext context) throws CoreException {
        }

        public void rollback(ISaveContext context) {
        }

        public void saving(ISaveContext context) throws CoreException {
            context.needDelta();
        }
    }
}

