/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.customengine.rules.genericRules;

import org.eclipse.ebam.customengine.IEbamBaseRule;
import org.eclipse.ebam.customengine.utils.MsgReadUtils;
import org.eclipse.ebam.event.EbamEvent;
import org.eclipse.ebam.event.IEbamEvent;
import org.eclipse.ebam.messages.EbamMessage;
import org.eclipse.ebam.messages.IEbamMessage;
import org.eclipse.ebam.model.entities.SbiAlarm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterRule
implements IEbamBaseRule {
    private SbiAlarm sbiAlarm = null;
    private String xPathFilter = null;
    int maxErrors = -1;
    private static Logger logger = LoggerFactory.getLogger(FilterRule.class);

    public void init(String config) {
        EbamMessage tempM = new EbamMessage();
        tempM.setMsg(config);
        this.xPathFilter = MsgReadUtils.extractByQuery((IEbamMessage)tempM, "//*/FILTER", null);
    }

    public IEbamEvent executeRule(IEbamMessage msg) {
        logger.debug("IN");
        IEbamEvent toReturn = null;
        boolean generateEvent = this.filter(msg);
        if (generateEvent) {
            toReturn = this.createEvent();
        }
        logger.debug("OUT");
        return toReturn;
    }

    public boolean filter(IEbamMessage msg) {
        boolean toReturn = false;
        if (this.xPathFilter != null) {
            String stato = MsgReadUtils.extractByQuery(msg, this.xPathFilter, null);
            toReturn = stato != null && !stato.equals("");
        }
        return toReturn;
    }

    public IEbamEvent createEvent() {
        EbamEvent ev = new EbamEvent();
        ev.setType("ALARM");
        if (this.sbiAlarm != null) {
            ev.setAlarm(this.sbiAlarm);
        } else {
            logger.warn("alarm not found");
        }
        return ev;
    }

    public SbiAlarm getSbiAlarm() {
        return this.sbiAlarm;
    }

    public void setSbiAlarm(SbiAlarm sbiAlarm) {
        this.sbiAlarm = sbiAlarm;
    }
}

